/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.exttable.columns;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.ExtTextArea;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtDefaultRowSorter;
import org.appwork.swing.exttable.ExtTableModel;
import org.appwork.swing.exttable.columns.CellHeightProvider;
import org.appwork.utils.swing.renderer.RendererMigPanel;

public abstract class ExtMultiLineTextColumn<E>
extends ExtColumn<E>
implements ActionListener,
FocusListener,
CellHeightProvider {
    private static final long serialVersionUID = 2114805529462086691L;
    protected RendererMigPanel renderer;
    protected MigPanel editor;
    private final Border defaultBorder = BorderFactory.createEmptyBorder(0, 5, 0, 5);
    private Color rendererForeground;
    private Color editorForeground;
    private Font rendererFont;
    private Font editorFont;
    protected JTextArea txt;
    protected final AtomicInteger noSet = new AtomicInteger(0);
    private int lastRow;
    private HashMap<Integer, Integer> heights = new HashMap();
    private ExtTextArea rendererLabel;
    private E lastValue;
    private JScrollPane scrollPane;
    private int lastEditorRow;
    private E lastEditorValue;
    private Border editorBorder;
    private Color editorBackground;

    public void setNoSet(boolean b) {
        if (b) {
            this.noSet.incrementAndGet();
        } else if (this.noSet.get() > 0) {
            this.noSet.decrementAndGet();
        }
    }

    @Override
    public int adjustRowHeight(int row, int height) {
        Integer ret = this.heights.get(row);
        if (ret != null) {
            return Math.max(ret, height);
        }
        return height;
    }

    public ExtMultiLineTextColumn(String name) {
        this(name, null);
    }

    public ExtMultiLineTextColumn(String name, ExtTableModel<E> table) {
        super(name, table);
        this.txt = new JTextArea();
        InputMap input = this.txt.getInputMap();
        KeyStroke enter = KeyStroke.getKeyStroke("ENTER");
        KeyStroke shiftEnter = KeyStroke.getKeyStroke("shift ENTER");
        Object oldEnter = input.get(enter);
        input.put(enter, "STOP_EDIT");
        input.put(shiftEnter, oldEnter);
        input.put(KeyStroke.getKeyStroke("ESCAPE"), "RESET_EDIT");
        ActionMap actions = this.txt.getActionMap();
        actions.put("RESET_EDIT", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtMultiLineTextColumn.this.setNoSet(true);
                try {
                    ExtMultiLineTextColumn.this.stopCellEditing();
                }
                finally {
                    ExtMultiLineTextColumn.this.setNoSet(false);
                }
            }
        });
        this.txt.setFocusTraversalKeysEnabled(false);
        this.scrollPane = new JScrollPane(this.txt);
        JTextField dummy = new JTextField();
        this.editorBorder = dummy.getBorder();
        this.editorBackground = dummy.getBackground();
        this.txt.addFocusListener(this);
        this.editor = new MigPanel(this.getEditorPanelLayout()){

            @Override
            public void validate() {
                super.validate();
                ExtMultiLineTextColumn.this.heights.put(ExtMultiLineTextColumn.this.lastEditorRow, Math.min(ExtMultiLineTextColumn.this.getMaxHeight(ExtMultiLineTextColumn.this.lastEditorValue), ExtMultiLineTextColumn.this.txt.getPreferredSize().height + 40));
            }

            @Override
            public void setBounds(int x, int y, int width, int height) {
                super.setBounds(x, y, width, height);
                ExtMultiLineTextColumn.this.scrollPane.setBounds(x, y, width, height);
            }
        };
        this.editor.add(this.scrollPane);
        this.renderer = new RendererMigPanel(this.getRendererPanelLayout()){

            @Override
            public void validate() {
                super.validate();
                ExtMultiLineTextColumn.this.heights.put(ExtMultiLineTextColumn.this.lastRow, Math.min(ExtMultiLineTextColumn.this.getMaxHeight(ExtMultiLineTextColumn.this.lastValue), this.getPreferredSize().height));
            }

            @Override
            public void setBounds(int x, int y, int width, int height) {
                super.setBounds(x, y, width, height);
                ExtMultiLineTextColumn.this.rendererLabel.setBounds(x, y, width, height);
            }
        };
        this.rendererLabel = new ExtTextArea();
        this.rendererLabel.setEditable(false);
        this.rendererLabel.setBorder(null);
        this.rendererLabel.setFocusable(false);
        this.rendererLabel.setLineWrap(true);
        this.rendererLabel.setWrapStyleWord(true);
        this.rendererLabel.setLabelMode(true);
        this.renderer.add(this.rendererLabel);
        this.rendererLabel.setOpaque(false);
        this.rendererForeground = this.rendererLabel.getForeground();
        this.rendererFont = this.rendererLabel.getFont();
        this.editorFont = this.txt.getFont();
        this.editorForeground = this.txt.getForeground();
        this.setRowSorter(new ExtDefaultRowSorter<E>(){

            @Override
            public int compare(E o1, E o2) {
                String o1s = ExtMultiLineTextColumn.this.getStringValue(o1);
                String o2s = ExtMultiLineTextColumn.this.getStringValue(o2);
                if (o1s == null) {
                    o1s = "";
                }
                if (o2s == null) {
                    o2s = "";
                }
                if (this.getSortOrderIdentifier() == "ASC") {
                    return o1s.compareTo(o2s);
                }
                return o2s.compareTo(o1s);
            }
        });
    }

    protected MigLayout getEditorPanelLayout() {
        return new MigLayout("ins 0 0 0 0", "[grow,fill]", "4[grow,fill]1");
    }

    protected MigLayout getRendererPanelLayout() {
        return new MigLayout("ins 0 0 0 0", "0[grow,fill]0", "7[]7");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.fireEditingStopped();
    }

    @Override
    public void configureEditorComponent(E value, boolean isSelected, int row, int column) {
        String str = this.getStringValue(value);
        if (str == null) {
            str = "";
        }
        this.lastEditorRow = row;
        this.lastEditorValue = value;
        this.txt.setText(str);
    }

    @Override
    public void configureRendererComponent(E value, boolean isSelected, boolean hasFocus, int row, int column) {
        String str = this.getStringValue(value);
        if (str == null) {
            str = "";
        }
        this.lastRow = row;
        this.lastValue = value;
        this.rendererLabel.setText(str);
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (!e.isTemporary() || e.getOppositeComponent() == null) {
            this.setNoSet(true);
            try {
                this.stopCellEditing();
            }
            finally {
                this.setNoSet(false);
            }
        }
    }

    @Override
    public Object getCellEditorValue() {
        return this.txt.getText();
    }

    @Override
    public JComponent getEditorComponent(E value, boolean isSelected, int row, int column) {
        return this.editor;
    }

    protected Icon getIcon(E value) {
        return null;
    }

    private int getMaxHeight(E value) {
        return 300;
    }

    @Override
    public JComponent getRendererComponent(E value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.renderer;
    }

    public abstract String getStringValue(E var1);

    @Override
    protected String getTooltipText(E obj) {
        String v = this.getStringValue(obj);
        if (v != null && v.length() > 0) {
            return v;
        }
        return null;
    }

    @Override
    public boolean isEditable(E obj) {
        return false;
    }

    @Override
    public boolean isEnabled(E obj) {
        return true;
    }

    @Override
    public boolean isSortable(E obj) {
        return true;
    }

    @Override
    public boolean matchSearch(E object, Pattern pattern) {
        String value = this.getStringValue(object);
        if (value == null) {
            return false;
        }
        return pattern.matcher(value).matches();
    }

    @Override
    public boolean onRenameClick(MouseEvent e, E obj) {
        if (this.isEditable(obj)) {
            this.startEditing(obj);
            return true;
        }
        return super.onRenameClick(e, obj);
    }

    @Override
    public void resetEditor() {
        this.scrollPane.setBorder(this.editorBorder);
        this.scrollPane.setBackground(this.editorBackground);
        this.scrollPane.setOpaque(true);
        this.txt.setFont(this.editorFont);
        this.txt.setForeground(this.editorForeground);
        this.editor.setOpaque(false);
        this.editor.setBackground(null);
        this.editor.putClientProperty("Synthetica.opaque", Boolean.FALSE);
        this.txt.setOpaque(false);
        this.txt.putClientProperty("Synthetica.opaque", Boolean.FALSE);
        this.txt.setBackground(null);
    }

    @Override
    public void resetRenderer() {
        this.renderer.setBorder(this.defaultBorder);
        this.renderer.setOpaque(false);
        this.renderer.setBackground(null);
        this.renderer.setFont(this.rendererFont);
        this.renderer.setForeground(this.rendererForeground);
    }

    protected void setStringValue(String value, E object) {
    }

    protected boolean noSet() {
        return this.noSet.get() > 0;
    }

    @Override
    public void setValue(Object value, E object) {
        if (!this.noSet()) {
            this.setStringValue((String)value, object);
        }
    }
}

