/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.txtresource;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.WeakHashMap;
import org.appwork.loggingv3.LogV3;
import org.appwork.txtresource.CustomTranslationInterface;
import org.appwork.txtresource.Defaults;
import org.appwork.txtresource.DescriptionForTranslationEntry;
import org.appwork.txtresource.DynamicResourcePath;
import org.appwork.txtresource.TranslateData;
import org.appwork.txtresource.TranslateInterface;
import org.appwork.txtresource.TranslateResource;
import org.appwork.txtresource.Translateable;
import org.appwork.txtresource.TranslatedEntry;
import org.appwork.txtresource.TranslationFactory;
import org.appwork.txtresource.TranslationSource;
import org.appwork.txtresource.TranslationUtils;
import org.appwork.utils.Application;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;

public class TranslationHandler
implements InvocationHandler {
    private final Class<? extends TranslateInterface> tInterface;
    private List<TranslateResource> lookup;
    private HashMap<Method, TranslatedEntry> cache;
    private final Method[] methods;
    private HashMap<String, TranslateResource> resourceCache;
    private boolean tryCustom;
    private HashMap<String, TranslatedEntry> overrides;
    public static final String DEFAULT = "en";
    private static final WeakHashMap<Thread, CustomTranslationInterface> CUSTOM_TRANSLATION_MAP = new WeakHashMap();

    public TranslationHandler(Class<? extends TranslateInterface> class1, String ... lookup) {
        this.tInterface = class1;
        this.tryCustom = Application.getResource("translations/custom").exists();
        this.methods = this.tInterface.getDeclaredMethods();
        this.cache = new HashMap();
        this.resourceCache = new HashMap();
        this.lookup = this.fillLookup(lookup);
    }

    private boolean checkTypes(Method m, Class<?>[] types) {
        Class<?>[] parameters = m.getParameterTypes();
        if (parameters.length != types.length) {
            return false;
        }
        if (types.length == 0) {
            return true;
        }
        for (int i = 0; i < types.length; ++i) {
            if (types[i] == parameters[i]) continue;
            if (Number.class.isAssignableFrom(types[i])) {
                if (parameters[i] == Integer.TYPE || parameters[i] == Long.TYPE || parameters[i] == Double.TYPE || parameters[i] == Float.TYPE || parameters[i] == Byte.TYPE || parameters[i] == Character.TYPE) continue;
                return false;
            }
            return types[i] == Boolean.class && parameters[i] == Boolean.TYPE;
        }
        return true;
    }

    public String createFile(String string, TranslationUtils.TranslationProviderInterface prov, boolean addComments) {
        TranslateData map = new TranslateData();
        this.cache.clear();
        this.lookup = this.fillLookup(string);
        TranslationHandler enDefault = new TranslationHandler(this.tInterface, DEFAULT);
        HashMap<Method, TranslationUtils.Translated> comments = new HashMap<Method, TranslationUtils.Translated>();
        for (Method m : this.tInterface.getDeclaredMethods()) {
            try {
                if (prov == null) {
                    map.put(m.getName(), new TranslatedEntry(this.invoke(null, m, null).toString()));
                    continue;
                }
                String enDefaultString = enDefault.invoke(null, m, null).toString();
                TranslationUtils.Translated trans = prov.get(m, string, this.invoke(null, m, null).toString(), enDefaultString);
                comments.put(m, trans);
                map.put(m.getName(), new TranslatedEntry(trans.value));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        String ret = TranslationUtils.serialize(map);
        if (addComments) {
            for (Method m : this.tInterface.getDeclaredMethods()) {
                String c;
                DescriptionForTranslationEntry desc = m.getAnnotation(DescriptionForTranslationEntry.class);
                String comment = "";
                TranslationUtils.Translated translated = (TranslationUtils.Translated)comments.get(m);
                if (translated != null && StringUtils.isNotEmpty(c = translated.comment)) {
                    comment = comment + "\r\n" + c;
                }
                if (desc != null) {
                    String d = desc.value().replaceAll("[\\\r\\\n]+", "\r\n");
                    comment = comment + "\r\nDescription:\r\n" + d;
                }
                if ((comment = comment.trim()).length() <= 0) continue;
                comment = "\t//\t" + comment.replaceAll("[\r\n]+", "\r\n\t//\t");
                ret = ret.replace(m.getName() + "=", comment + "\r\n" + m.getName() + "=");
            }
        }
        return ret;
    }

    private TranslateResource createTranslationResource(String isoCode) throws IOException, InstantiationException, IllegalAccessException {
        Defaults ann;
        TranslateResource ret = this.resourceCache.get(isoCode);
        if (ret != null) {
            return ret;
        }
        DynamicResourcePath rPath = this.tInterface.getAnnotation(DynamicResourcePath.class);
        String path = null;
        URL urlClasspath = null;
        URL urlFilesystem = null;
        if (this.tryCustom) {
            path = rPath != null ? "translations/custom/" + rPath.value().newInstance().getPath() + "." + isoCode + ".lng" : "translations/custom/" + this.tInterface.getName().replace(".", "/") + "." + isoCode + ".lng";
            urlFilesystem = this.getRessourceURLFS(path);
            urlClasspath = this.getRessourceURLCP(path);
            if (urlFilesystem != null || urlClasspath != null) {
                LogV3.finer("Load Custom Translation " + urlFilesystem + "/" + urlClasspath);
            }
        }
        if (urlFilesystem == null && urlClasspath == null) {
            path = rPath != null ? "translations/" + rPath.value().newInstance().getPath() + "." + isoCode + ".lng" : "translations/" + this.tInterface.getName().replace(".", "/") + "." + isoCode + ".lng";
            urlFilesystem = this.getRessourceURLFS(path);
            urlClasspath = this.getRessourceURLCP(path);
            if (urlFilesystem != null || urlClasspath != null) {
                LogV3.finer("Load Translation " + urlFilesystem + "/" + urlClasspath);
            }
        }
        if (urlFilesystem == null && urlClasspath == null) {
            path = rPath != null ? this.tInterface.getPackage().getName().replace(".", "/") + "/" + rPath.value().newInstance().getPath() + "." + isoCode + ".lng" : this.tInterface.getName().replace(".", "/") + "." + isoCode + ".lng";
            urlFilesystem = this.getRessourceURLFS(path);
            urlClasspath = this.getRessourceURLCP(path);
            if (urlFilesystem != null || urlClasspath != null) {
                LogV3.finer("Load Neighbour Translation " + urlFilesystem + "/" + urlClasspath);
            }
        }
        if (urlFilesystem == null && urlClasspath == null && rPath != null) {
            path = rPath.value().newInstance().getPath();
            urlFilesystem = this.getRessourceURLFS(path);
            urlClasspath = this.getRessourceURLCP(path);
            if (urlFilesystem != null || urlClasspath != null) {
                LogV3.finer("Load DynamicResourcePath Translation " + urlFilesystem + "/" + urlClasspath);
            }
        }
        if (urlFilesystem == null && urlClasspath == null && (ann = this.tInterface.getAnnotation(Defaults.class)) != null) {
            for (String d : ann.lngs()) {
                if (!d.equals(isoCode)) continue;
                LogV3.info("Translation file missing:" + path + "Use Annotation Dev fallback");
                break;
            }
        }
        ret = new TranslateResource(urlFilesystem, urlClasspath, isoCode);
        this.resourceCache.put(isoCode, ret);
        return ret;
    }

    private URL getRessourceURLCP(String relative) {
        URL res = Application.class.getClassLoader().getResource(relative);
        return res;
    }

    private URL getRessourceURLFS(String relative) {
        File file = new File(Application.getHome(), relative);
        if (file.exists()) {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                LogV3.log(e);
            }
        }
        return null;
    }

    private List<TranslateResource> fillLookup(String ... lookup) {
        ArrayList<TranslateResource> ret = new ArrayList<TranslateResource>();
        boolean containsDefault = false;
        if (lookup != null) {
            for (String oo : lookup) {
                if (oo == null) continue;
                for (String o : TranslationFactory.getVariantsOf(oo)) {
                    try {
                        if (DEFAULT.equals(o)) {
                            containsDefault = true;
                        }
                        TranslateResource res = this.createTranslationResource(o);
                        if (ret == null) continue;
                        ret.add(res);
                    }
                    catch (NullPointerException e) {
                        LogV3.warning(e.getMessage());
                    }
                    catch (Throwable e) {
                        LogV3.log(e);
                    }
                }
            }
        }
        if (!containsDefault) {
            try {
                TranslateResource res = this.createTranslationResource(DEFAULT);
                if (res != null) {
                    ret.add(res);
                }
            }
            catch (Throwable e) {
                LogV3.log(e);
            }
        }
        return ret;
    }

    public String getDefault(Method method) {
        TranslateResource res = this.resourceCache.get(DEFAULT);
        if (res == null) {
            return null;
        }
        TranslatedEntry def = res.readDefaults(method);
        if (def != null) {
            return def.getRaw();
        }
        return null;
    }

    public Method[] getMethods() {
        return this.methods;
    }

    public String getTranslation(Method method, Object ... params) {
        return this.getValue(method, this.lookup).getRaw();
    }

    public String getTranslation(String languageKey, String methodname, Object ... params) {
        Class[] types = new Class[params == null ? 0 : params.length];
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                types[i] = params[i].getClass();
            }
        }
        for (Method m : this.methods) {
            if (!m.getName().equals(methodname) || !this.checkTypes(m, types)) continue;
            TranslatedEntry ret = this.getValue(m, this.fillLookup(languageKey));
            if (ret == null) {
                return null;
            }
            return ret.format(m, params);
        }
        return null;
    }

    public TranslatedEntry getValue(Method method, List<TranslateResource> lookup) {
        TranslatedEntry ret = null;
        if (this.overrides != null && (ret = this.overrides.get(method.getName())) != null) {
            return ret;
        }
        for (TranslateResource res : lookup) {
            try {
                ret = res.getEntry(method);
                if (ret == null) continue;
                return ret;
            }
            catch (Throwable e) {
                LogV3.warning("Exception in translation: " + this.tInterface.getName() + "." + res.getName());
                LogV3.log(e);
            }
        }
        if (ret == null) {
            ret = new TranslatedEntry(this.tInterface.getSimpleName() + "." + method.getName());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CustomTranslationInterface setCustomTranslation(CustomTranslationInterface customTranslation) {
        WeakHashMap<Thread, CustomTranslationInterface> weakHashMap = CUSTOM_TRANSLATION_MAP;
        synchronized (weakHashMap) {
            if (customTranslation == null) {
                return CUSTOM_TRANSLATION_MAP.remove(Thread.currentThread());
            }
            return CUSTOM_TRANSLATION_MAP.put(Thread.currentThread(), customTranslation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CustomTranslationInterface clearCustomTranslation() {
        WeakHashMap<Thread, CustomTranslationInterface> weakHashMap = CUSTOM_TRANSLATION_MAP;
        synchronized (weakHashMap) {
            return CUSTOM_TRANSLATION_MAP.remove(Thread.currentThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CustomTranslationInterface getCustomTranslation() {
        WeakHashMap<Thread, CustomTranslationInterface> weakHashMap = CUSTOM_TRANSLATION_MAP;
        synchronized (weakHashMap) {
            return CUSTOM_TRANSLATION_MAP.get(Thread.currentThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
        List<TranslateResource> lookup = this.lookup;
        if (method.getDeclaringClass() == Object.class) {
            return method.invoke((Object)this, args);
        }
        if (method.getName().equals("_getHandler")) {
            return this;
        }
        CustomTranslationInterface customTranslation = this.getCustomTranslation();
        if (customTranslation != null) {
            return customTranslation.getTranslation(this, proxy, method, args);
        }
        if (Translateable.class.isAssignableFrom(method.getReturnType())) {
            return new Translateable(){

                @Override
                public String translate(String ... localePriority) {
                    TranslatedEntry ret;
                    if (TranslationHandler.this.overrides != null && (ret = (TranslatedEntry)TranslationHandler.this.overrides.get(method.getName())) != null) {
                        return ret.format(method, args);
                    }
                    for (TranslateResource l : TranslationHandler.this.fillLookup(localePriority)) {
                        try {
                            TranslatedEntry ret2 = l.getEntry(method);
                            if (ret2 == null) continue;
                            return ret2.format(method, args);
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                    return null;
                }

                @Override
                public String getKey() {
                    return method.getName();
                }
            };
        }
        HashMap<Method, TranslatedEntry> lcache = this.cache;
        TranslatedEntry ret = null;
        HashMap<Method, TranslatedEntry> hashMap = lcache;
        synchronized (hashMap) {
            ret = lcache.get(method);
            if (ret == null && (ret = this.getValue(method, lookup)) != null) {
                lcache.put(method, ret);
            }
        }
        return ret.format(method, args);
    }

    public void setLanguage(String loc) {
        this.cache = new HashMap();
        this.resourceCache = new HashMap();
        this.lookup = this.fillLookup(loc);
    }

    public TranslationSource getSource(Method method) {
        TranslationSource ret = null;
        for (TranslateResource res : this.lookup) {
            try {
                ret = res.getSource(method);
                if (ret == null) continue;
                return ret;
            }
            catch (Throwable e) {
                LogV3.warning("Exception in translation: " + this.tInterface.getName() + "." + res.getName());
                LogV3.log(e);
            }
        }
        return ret;
    }

    public String getID() {
        return this.lookup.get(0).getName();
    }

    public String getExistingID() {
        for (TranslateResource l : this.lookup) {
            if (l.getData() == null) continue;
            return l.getName();
        }
        return null;
    }

    public TranslateResource getResource(String id) {
        for (TranslateResource tr : this.lookup) {
            if (!tr.getName().equals(id)) continue;
            return tr;
        }
        return null;
    }

    public Class<? extends TranslateInterface> getInterfaceClass() {
        return this.tInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void overwrite(String key, String value) {
        HashMap<String, TranslatedEntry> tmp = new HashMap<String, TranslatedEntry>();
        if (this.overrides != null) {
            tmp.putAll(this.overrides);
        }
        tmp.put(key, new TranslatedEntry(value));
        for (Method m : this.methods) {
            if (!m.getName().equals(key)) continue;
            HashMap<Method, TranslatedEntry> hashMap = this.cache;
            synchronized (hashMap) {
                this.cache.remove(m);
            }
        }
        this.overrides = tmp;
    }

    public String replaceWildCards(String message) {
        if (!message.contains("%")) {
            return message;
        }
        String[] matches = new Regex(message, "\\%([a-z0-9A-Z_]+)\\%").getColumn(0);
        if (matches == null) {
            return message;
        }
        for (String placeholder : matches) {
            String replace = this.getTranslation(this.getID(), placeholder, new Object[0]);
            if (replace == null) continue;
            message = message.replace("%" + placeholder + "%", replace);
        }
        return message;
    }
}

