/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.updatesys.client.lastchance;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.appwork.updatesys.client.lastchance.LastChanceInterface;

public class RemovableClassLoader
extends URLClassLoader {
    private final File jarFile;

    public RemovableClassLoader(File jarFile) throws IOException {
        super(new URL[]{jarFile.toURI().toURL()}, RemovableClassLoader.class.getClassLoader());
        this.jarFile = jarFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object lock = this;
        try {
            lock = this.getClassLoadingLock(name);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        RemovableClassLoader removableClassLoader = lock;
        synchronized (removableClassLoader) {
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                String resource = name.replace(".", "/") + ".class";
                if (this.findResource(resource) != null) {
                    c = this.findClass(name);
                } else {
                    return super.loadClass(name, resolve);
                }
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Class<LastChanceInterface>> listLastChanceInterfaces() throws URISyntaxException, FileNotFoundException, IOException, ClassNotFoundException {
        ArrayList<Class<LastChanceInterface>> ret = new ArrayList<Class<LastChanceInterface>>();
        Class<LastChanceInterface> assignableFromClass = LastChanceInterface.class;
        FileInputStream fis = new FileInputStream(this.jarFile);
        try {
            JarInputStream jis = new JarInputStream(fis);
            try {
                JarEntry e = null;
                while ((e = jis.getNextJarEntry()) != null) {
                    String name = e.getName();
                    if (!name.endsWith(".class")) continue;
                    String classPath = name.replace("/", ".");
                    Class<?> loadedClass = this.loadClass(classPath = classPath.substring(0, classPath.length() - 6));
                    if (loadedClass == null || loadedClass == assignableFromClass || assignableFromClass != null && !assignableFromClass.isAssignableFrom(loadedClass)) continue;
                    ret.add(loadedClass);
                }
            }
            finally {
                try {
                    jis.close();
                }
                catch (Throwable throwable) {}
            }
        }
        finally {
            try {
                fis.close();
            }
            catch (Throwable throwable) {}
        }
        return ret;
    }
}

