/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class AutoCloseInputStream
extends FilterInputStream {
    private boolean closed = false;

    public AutoCloseInputStream(InputStream is) {
        super(is);
    }

    @Override
    public int read() throws IOException {
        int ret;
        try {
            ret = super.read();
        }
        catch (IOException e) {
            this.autoClose();
            throw e;
        }
        if (ret < 0) {
            this.autoClose();
        }
        return ret;
    }

    private void autoClose() throws IOException {
        if (this.closed) {
            return;
        }
        this.close();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.closed = true;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int ret;
        try {
            ret = super.read(b);
        }
        catch (IOException e) {
            this.autoClose();
            throw e;
        }
        if (ret < 0) {
            this.autoClose();
        }
        return ret;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int ret;
        try {
            ret = super.read(b, off, len);
        }
        catch (IOException e) {
            this.autoClose();
            throw e;
        }
        if (ret < 0) {
            this.autoClose();
        }
        return ret;
    }
}

