/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.appwork.exceptions.WTFException;
import org.appwork.utils.Files;
import org.appwork.utils.ZipContentHasher;

public abstract class ClassPathScanner<E extends Throwable> {
    public abstract void handle(Class<?> var1) throws E;

    public static List<URL> getClassPath() {
        return ClassPathScanner.getClassPath(Thread.currentThread().getContextClassLoader());
    }

    public static List<URL> getBootClassPath() {
        ArrayList<URL> urls = new ArrayList<URL>();
        String classPath = System.getProperty("sun.boot.class.path");
        if (classPath != null) {
            String[] classPathEntries;
            for (String classPathEntry : classPathEntries = classPath.split(File.pathSeparator)) {
                try {
                    urls.add(new File(classPathEntry).toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new WTFException(e);
                }
            }
        }
        return urls;
    }

    public static List<URL> getClassPath(ClassLoader cl) {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (cl instanceof URLClassLoader) {
            urls.addAll(Arrays.asList(((URLClassLoader)cl).getURLs()));
        } else {
            String[] classPathEntries;
            String classPath = System.getProperty("java.class.path");
            for (String classPathEntry : classPathEntries = classPath.split(File.pathSeparator)) {
                try {
                    urls.add(new File(classPathEntry).toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new WTFException(e);
                }
            }
        }
        if (urls.size() == 0) {
            throw new WTFException("empty classPath?!");
        }
        return urls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws E {
        for (URL url : ClassPathScanner.getClassPath()) {
            try {
                Class<?> cls;
                File root = new File(url.toURI());
                if (root.isDirectory()) {
                    List<File> files = Files.getFiles(true, true, root);
                    for (File file : files) {
                        String rel = Files.getRelativePath(root, file);
                        if (!file.isFile() || !rel.toUpperCase(Locale.ROOT).endsWith(".CLASS")) continue;
                        cls = null;
                        try {
                            String name = rel.replace("/", ".").substring(0, rel.length() - ".class".length());
                            if (this.skip(name)) continue;
                            cls = Class.forName(name, false, Thread.currentThread().getContextClassLoader());
                        }
                        catch (Throwable name) {
                            // empty catch block
                        }
                        if (cls == null) continue;
                        this.handle(cls, root);
                    }
                    continue;
                }
                if (!root.isFile() || !root.getName().toUpperCase(Locale.ROOT).endsWith(".JAR")) continue;
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(root);
                    for (Map.Entry entry : ZipContentHasher.getHashes("", fis, new ZipContentHasher.Customizer(){

                        @Override
                        public boolean handle(String path, ZipInputStream zipStream, ZipEntry entry, HashMap<String, byte[]> results) throws IOException {
                            return path.endsWith(".class");
                        }
                    }, false).entrySet()) {
                        String classname;
                        if (!((String)entry.getKey()).endsWith(".class") || this.skip(classname = ((String)entry.getKey()).replaceAll("[\\/\\\\]", ".").replaceAll("\\.class$", ""))) continue;
                        cls = null;
                        try {
                            cls = Class.forName(classname);
                        }
                        catch (Throwable e) {
                            continue;
                        }
                        this.handle(cls, root);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        if (fis == null) continue;
                        fis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (URISyntaxException e1) {
                e1.printStackTrace();
            }
        }
    }

    protected void handle(Class<?> cls, File root) throws E {
        this.handle(cls);
    }

    protected boolean skip(String classname) {
        if (classname.startsWith("net.miginfocom.")) {
            return true;
        }
        if (classname.startsWith("org.slf4j.")) {
            return true;
        }
        if (classname.startsWith("org.tmatesoft.")) {
            return true;
        }
        if (classname.startsWith("com.")) {
            return true;
        }
        if (classname.startsWith("de.")) {
            return true;
        }
        if (classname.startsWith("org.eclipse.")) {
            return true;
        }
        if (classname.startsWith("org.tukaani.")) {
            return true;
        }
        if (classname.startsWith("cx.")) {
            return true;
        }
        if (classname.startsWith("org.freedesktop.")) {
            return true;
        }
        if (classname.startsWith("net.sf.sevenzipjbinding.")) {
            return true;
        }
        if (classname.startsWith("org.junit.")) {
            return true;
        }
        if (classname.startsWith("org.fourthline.")) {
            return true;
        }
        if (classname.startsWith("META-INF.")) {
            return true;
        }
        if (classname.startsWith("org.bouncycastle.")) {
            return true;
        }
        if (classname.startsWith("org.mozilla.")) {
            return true;
        }
        if (classname.startsWith("net.sourceforge.")) {
            return true;
        }
        if (classname.startsWith("net.sf.")) {
            return true;
        }
        if (classname.startsWith("org.antlr.")) {
            return true;
        }
        if (classname.startsWith("jsyntaxpane.")) {
            return true;
        }
        if (classname.startsWith("org.seamless.")) {
            return true;
        }
        if (classname.startsWith("org.brotli.")) {
            return true;
        }
        if (classname.startsWith("org.hamcrest.")) {
            return true;
        }
        if (classname.startsWith("junit.")) {
            return true;
        }
        if (classname.startsWith("dbus")) {
            return true;
        }
        if (classname.startsWith("org.schwering.")) {
            return true;
        }
        if (classname.startsWith("net.lingala.")) {
            return true;
        }
        return classname.startsWith("module-info");
    }
}

