/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.io.IOException;

public class ExtIOException
extends IOException {
    private String streamInfo;
    private String desc;
    private IOExceptionType type;

    public ExtIOException(Throwable e, IOExceptionType type) {
        super(e);
        this.type = type;
    }

    public ExtIOException getOriginCause() {
        ExtIOException last = null;
        ExtIOException deepest = this;
        for (Throwable e = this; e != null && (last == null || last != e.getCause()); e = e.getCause()) {
            if (e instanceof ExtIOException) {
                deepest = e;
            }
            last = e;
        }
        return deepest;
    }

    public ExtIOException(Throwable e, IOExceptionType type, String message) {
        super(message, e);
        this.type = type;
    }

    public static ExtIOException getInstance(Throwable e, IOExceptionType type) {
        if (e instanceof ExtIOException && ((ExtIOException)e).type == type) {
            return (ExtIOException)e;
        }
        return new ExtIOException(e, type);
    }

    public ExtIOException(String msg, Throwable e, IOExceptionType type, String streamInfo) {
        super(msg + "( " + streamInfo + ")", e);
        this.type = type;
        this.desc = msg;
        this.streamInfo = streamInfo;
    }

    public ExtIOException(Throwable e, IOExceptionType type, String msg, String streamInfo) {
        super(msg + "( " + streamInfo + ")", e);
        this.type = type;
        this.desc = msg;
        this.streamInfo = streamInfo;
    }

    public ExtIOException(String msg, IOExceptionType type, String streaminfo) {
        super(msg + "( " + streaminfo + ")");
        this.type = type;
        this.desc = msg;
        this.streamInfo = streaminfo;
    }

    public String getDescription() {
        return this.desc;
    }

    public String getStreamInfo() {
        return this.streamInfo;
    }

    public static enum IOExceptionType {
        LOCAL,
        REMOTE;

    }
}

