/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.io.File;
import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.appwork.loggingv3.LogV3;
import org.appwork.utils.Exceptions;
import org.appwork.utils.Hash;
import org.appwork.utils.Time;
import org.appwork.utils.os.CrossSystem;

public class Files17 {
    private static final HashMap<String, List<FileStore>> FILESTORECACHE = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterable<FileStore> getFileStores() {
        File mtab;
        FileSystem fileSystem = FileSystems.getDefault();
        if (fileSystem.getClass().getName().endsWith("LinuxFileSystem") && (mtab = new File("/etc/mtab")).isFile()) {
            String cacheID = Hash.getSHA256(mtab);
            HashMap<String, List<FileStore>> hashMap = FILESTORECACHE;
            synchronized (hashMap) {
                List<FileStore> cache = FILESTORECACHE.get(cacheID);
                if (cache != null) {
                    LogV3.logger(Files17.class).info("getFileStores|cached|size:" + cache.size());
                    return cache;
                }
                ArrayList<FileStore> fileStores = new ArrayList<FileStore>();
                long startTimeStamp = Time.systemIndependentCurrentJVMTimeMillis();
                try {
                    for (FileStore fileStore : fileSystem.getFileStores()) {
                        fileStores.add(fileStore);
                    }
                }
                finally {
                    LogV3.logger(Files17.class).info("getFileStores|duration:" + (Time.systemIndependentCurrentJVMTimeMillis() - startTimeStamp) + "|size:" + fileStores.size());
                }
                FILESTORECACHE.clear();
                FILESTORECACHE.put(cacheID, fileStores);
                return fileStores;
            }
        }
        return fileSystem.getFileStores();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FileStore getFileStore(Path path) throws IOException {
        try {
            return Files.getFileStore(path);
        }
        catch (FileSystemException fse) {
            if (!CrossSystem.isWindows()) throw fse;
            if (path.getNameCount() != 0) {
                if (path.getNameCount() != 1) throw fse;
                if (Files.isDirectory(path, new LinkOption[0])) throw fse;
            }
            try {
                Stream<Path> pathStream = null;
                try {
                    FileStore ret;
                    Path next;
                    pathStream = !Files.isDirectory(path, new LinkOption[0]) ? Files.list(path.getParent()) : Files.list(path);
                    Iterator it = pathStream.iterator();
                    do {
                        if (!it.hasNext()) return null;
                    } while (!Files.isDirectory(next = (Path)it.next(), new LinkOption[0]));
                    FileStore fileStore = ret = Files.getFileStore(next);
                    return fileStore;
                }
                finally {
                    if (pathStream != null) {
                        pathStream.close();
                    }
                }
            }
            catch (IOException io) {
                throw Exceptions.addSuppressed(fse, io);
            }
        }
    }

    public static Path guessRoot(Path path) throws IOException {
        Object lastFileStore = null;
        Path lastPath = null;
        for (Path currentPath = path; currentPath != null; currentPath = currentPath.getParent()) {
            if (!Files.exists(currentPath, new LinkOption[0])) continue;
            FileStore fileStore = Files17.getFileStore(currentPath);
            if (lastFileStore != null && !lastFileStore.equals(fileStore)) break;
            lastPath = currentPath;
            lastFileStore = fileStore;
        }
        if (lastFileStore != null) {
            return lastPath;
        }
        return null;
    }

    protected static boolean deleteIfExists(File file) throws IOException {
        return Files17.deleteIfExists(file.toPath());
    }

    public static boolean deleteIfExists(Path path) throws IOException {
        try {
            return Files.deleteIfExists(path);
        }
        catch (ClosedByInterruptException e) {
            throw e;
        }
        catch (IOException e) {
            if (path.toFile().setWritable(true)) {
                return Files.deleteIfExists(path);
            }
            throw e;
        }
    }

    public static Long getUsableSpace(Path path) throws IOException {
        for (Path currentPath = path; currentPath != null; currentPath = currentPath.getParent()) {
            if (!Files.exists(currentPath, new LinkOption[0])) continue;
            FileStore fileStore = Files17.getFileStore(currentPath);
            if (fileStore == null) break;
            return fileStore.getUsableSpace();
        }
        return null;
    }
}

