/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils;

import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ModifyLock {
    protected final ReentrantReadWriteLock lock;

    public ModifyLock() {
        this(new ReentrantReadWriteLock());
    }

    public ModifyLock(ReentrantReadWriteLock lock) {
        if (lock == null) {
            throw new IllegalArgumentException("lock is null");
        }
        this.lock = lock;
    }

    public final boolean readLock() {
        if (!this.lock.writeLock().isHeldByCurrentThread()) {
            this.lock.readLock().lock();
            return true;
        }
        return false;
    }

    public final boolean tryWriteLock() {
        return this.lock.writeLock().tryLock();
    }

    public final boolean isWriteLocked() {
        return this.lock.isWriteLocked();
    }

    public final boolean isWriteLockedByCurrentThread() {
        return this.lock.isWriteLockedByCurrentThread();
    }

    public final boolean isReadLocked() {
        return this.lock.getReadLockCount() > 0;
    }

    public final void readUnlock(boolean state) throws IllegalMonitorStateException {
        if (!state) {
            return;
        }
        this.lock.readLock().unlock();
    }

    public final void runReadLock(Runnable run) {
        boolean readL = this.readLock();
        try {
            run.run();
        }
        finally {
            this.readUnlock(readL);
        }
    }

    public final void runWriteLock(Runnable run) {
        this.writeLock();
        try {
            run.run();
        }
        finally {
            this.writeUnlock();
        }
    }

    public final void writeLock() {
        this.lock.writeLock().lock();
    }

    public final void writeUnlock() throws IllegalMonitorStateException {
        this.lock.writeLock().unlock();
    }
}

