/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.encoding;

import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.appwork.utils.Regex;
import org.appwork.utils.encoding.Base64;

public class RFC2047 {
    protected static final String PATTERN_RELAXED = "(=(\\?|_)(.*?)\\2(B|b|Q|q)\\2(.+?)\\2=)";
    protected static final String PATTERN_STRICT = "(=(\\?)(.*?)\\2(B|b|Q|q)\\2(.+?)\\2=)";

    protected Matcher getMatcher(CharSequence in, boolean relaxed) {
        Matcher matcher = relaxed ? Pattern.compile(PATTERN_RELAXED).matcher(in) : Pattern.compile(PATTERN_STRICT).matcher(in);
        return matcher;
    }

    public CharSequence decode(CharSequence in) {
        try {
            return this.decode(in, false, false);
        }
        catch (IOException e) {
            return in;
        }
    }

    public CharSequence decode(CharSequence in, boolean relaxed) throws IOException {
        return this.decode(in, relaxed, false);
    }

    public CharSequence decode(CharSequence in, boolean relaxed, boolean throwException) throws IOException {
        Matcher matcher = this.getMatcher(in, relaxed);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            int end;
            int start = matcher.start();
            CharSequence match = in.subSequence(start, end = matcher.end());
            Result next = this.decodeSingle(match, relaxed, throwException);
            if (next == null) continue;
            matcher.appendReplacement(sb, Matcher.quoteReplacement(next.getOutput().toString()));
        }
        if (sb.length() == 0) {
            return in;
        }
        matcher.appendTail(sb);
        return sb;
    }

    protected CharSequence decode(Encoding encoding, CharSequence encoded, Charset charSet) throws IOException {
        return encoding.decode(encoded, charSet);
    }

    protected String[] getSingleMatch(CharSequence input, boolean relaxed) {
        String[] ret = relaxed ? new Regex(input, "^(=(\\?|_)(.*?)\\2(B|b|Q|q)\\2(.+?)\\2=)$").getRow(0) : new Regex(input, "^(=(\\?)(.*?)\\2(B|b|Q|q)\\2(.+?)\\2=)$").getRow(0);
        return ret;
    }

    protected Result decodeSingle(CharSequence input, boolean relaxed, boolean throwException) throws IOException {
        block6: {
            String[] rfc2047 = this.getSingleMatch(input, relaxed);
            if (rfc2047 != null) {
                try {
                    final Encoding encoding = Encoding.valueOf(rfc2047[3].toUpperCase(Locale.ENGLISH));
                    final String in = rfc2047[0];
                    String charSetString = rfc2047[2].trim();
                    int index = charSetString.indexOf(42);
                    if (index != -1) {
                        charSetString = charSetString.substring(0, index);
                    }
                    final Charset charSet = Charset.forName(charSetString);
                    final String encoded = rfc2047[4];
                    final CharSequence out = this.decode(encoding, encoded, charSet);
                    return new Result(){

                        @Override
                        public Encoding getEncoding() {
                            return encoding;
                        }

                        @Override
                        public CharSequence getInput() {
                            return in;
                        }

                        @Override
                        public CharSequence getOutput() {
                            return out;
                        }

                        @Override
                        public Charset getCharset() {
                            return charSet;
                        }

                        @Override
                        public CharSequence getEncoded() {
                            return encoded;
                        }
                    };
                }
                catch (IOException e) {
                    if (throwException) {
                        throw e;
                    }
                }
                catch (Exception e) {
                    if (!throwException) break block6;
                    throw new IOException(e);
                }
            }
        }
        return null;
    }

    public static abstract class Result {
        public abstract Encoding getEncoding();

        public abstract CharSequence getInput();

        public abstract CharSequence getOutput();

        public abstract CharSequence getEncoded();

        public abstract Charset getCharset();

        public String toString() {
            return "Encoding:" + (Object)((Object)this.getEncoding()) + "|Charset:" + this.getCharset() + "|Output:" + this.getOutput();
        }
    }

    public static enum Encoding {
        B{

            @Override
            public CharSequence decode(CharSequence encoded, Charset charSet) throws IOException {
                String decoded = new String(Base64.decode(encoded), charSet);
                String out = URLDecoder.decode(decoded, charSet.displayName());
                return out;
            }
        }
        ,
        Q{

            @Override
            public CharSequence decode(CharSequence encoded, Charset charSet) throws IOException {
                StringBuffer sb = new StringBuffer();
                Matcher matcher = Pattern.compile("(=[a-fA-F0-9]{2})+").matcher(encoded);
                while (matcher.find()) {
                    int start = matcher.start();
                    int end = matcher.end();
                    CharSequence match = encoded.subSequence(start, end);
                    matcher.appendReplacement(sb, Matcher.quoteReplacement(URLDecoder.decode(match.toString().replace("=", "%"), charSet.name())));
                }
                if (sb.length() == 0) {
                    return encoded;
                }
                matcher.appendTail(sb);
                return sb;
            }
        };


        public abstract CharSequence decode(CharSequence var1, Charset var2) throws IOException;
    }
}

