/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.event;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.appwork.utils.event.DefaultEvent;
import org.appwork.utils.event.EventSuppressor;

public abstract class Eventsender<ListenerType extends EventListener, EventType extends DefaultEvent> {
    protected volatile transient Set<EventSuppressor<EventType>> eventSuppressors = new CopyOnWriteArraySet<EventSuppressor<EventType>>();
    protected volatile transient List<ListenerType> strongListeners = null;
    protected volatile transient List<WeakReference<ListenerType>> weakListener = null;
    public final Object LOCK = new Object();

    public Eventsender() {
        this.strongListeners = new ArrayList<ListenerType>();
        this.weakListener = new ArrayList<WeakReference<ListenerType>>();
    }

    public void addAllListener(List<ListenerType> listener) {
        this.addAllListener(listener, false);
    }

    public void addAllListener(List<ListenerType> listener, boolean weak) {
        for (EventListener l : listener) {
            this.addListener(l, weak);
        }
    }

    public void addEventSuppressor(EventSuppressor<EventType> eventSuppressor) {
        if (eventSuppressor != null) {
            this.eventSuppressors.add(eventSuppressor);
        }
    }

    public void addListener(ListenerType t) {
        this.addListener(t, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ListenerType listener, boolean weakFlag) {
        if (listener == null) {
            return;
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (!weakFlag && !this.strongListeners.contains(listener)) {
                ArrayList<ListenerType> newStrongListener = new ArrayList<ListenerType>(this.strongListeners);
                newStrongListener.add(listener);
                this.strongListeners = newStrongListener;
            }
            for (WeakReference<ListenerType> weak : this.weakListener) {
                if (weak.get() != listener) continue;
                return;
            }
            ArrayList<WeakReference<ListenerType>> newWeakListener = new ArrayList<WeakReference<ListenerType>>(this.weakListener.size());
            for (WeakReference<ListenerType> weak : this.weakListener) {
                if (weak.get() == null) continue;
                newWeakListener.add(weak);
            }
            newWeakListener.add(new WeakReference<ListenerType>(listener));
            this.weakListener = newWeakListener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.weakListener.size() > 0) {
                ArrayList<WeakReference<ListenerType>> newWeakListener = new ArrayList<WeakReference<ListenerType>>(this.weakListener.size());
                for (WeakReference<ListenerType> listener : this.weakListener) {
                    if (listener.get() == null) continue;
                    newWeakListener.add(listener);
                }
                this.weakListener = newWeakListener;
            }
        }
    }

    public boolean containsListener(ListenerType t) {
        if (t == null) {
            return false;
        }
        EventListener l = null;
        List<WeakReference<ListenerType>> listeners = this.weakListener;
        for (WeakReference<ListenerType> listener : listeners) {
            l = (EventListener)listener.get();
            if (l == null || l != t) continue;
            return true;
        }
        return false;
    }

    public final void fireEvent(EventType event) {
        if (event == null) {
            return;
        }
        for (EventSuppressor<EventType> eventSuppressor : this.eventSuppressors) {
            if (!eventSuppressor.suppressEvent(event)) continue;
            return;
        }
        EventListener t = null;
        boolean cleanup = false;
        List<WeakReference<ListenerType>> listeners = this.weakListener;
        for (WeakReference<ListenerType> listener : listeners) {
            t = (EventListener)listener.get();
            if (t == null) {
                cleanup = true;
                continue;
            }
            this.fireEvent(t, event);
        }
        if (cleanup) {
            this.cleanup();
        }
    }

    protected abstract void fireEvent(ListenerType var1, EventType var2);

    public List<ListenerType> getListener() {
        List<WeakReference<ListenerType>> listeners = this.weakListener;
        boolean cleanup = true;
        ArrayList<EventListener> ret = new ArrayList<EventListener>(listeners.size());
        EventListener t = null;
        for (WeakReference<ListenerType> listener : listeners) {
            t = (EventListener)listener.get();
            if (t != null) {
                ret.add(t);
                continue;
            }
            cleanup = true;
        }
        if (cleanup) {
            this.cleanup();
        }
        return ret;
    }

    public boolean hasListener() {
        if (!this.strongListeners.isEmpty()) {
            return true;
        }
        List<WeakReference<ListenerType>> listeners = this.weakListener;
        for (WeakReference<ListenerType> listener : listeners) {
            if (listener.get() == null) continue;
            return true;
        }
        return false;
    }

    public void removeEventSuppressor(EventSuppressor<EventType> eventSuppressor) {
        if (eventSuppressor != null) {
            this.eventSuppressors.remove(eventSuppressor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ListenerType t) {
        if (t == null) {
            return;
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (this.weakListener.size() > 0) {
                EventListener l = null;
                ArrayList<WeakReference<ListenerType>> newWeakListener = new ArrayList<WeakReference<ListenerType>>(this.weakListener.size());
                for (WeakReference<ListenerType> listener : this.weakListener) {
                    l = (EventListener)listener.get();
                    if (l == null || l == t) continue;
                    newWeakListener.add(listener);
                }
                this.weakListener = newWeakListener;
            }
            if (this.strongListeners.contains(t)) {
                ArrayList<ListenerType> newStrongListener = new ArrayList<ListenerType>(this.strongListeners);
                newStrongListener.remove(t);
                this.strongListeners = newStrongListener;
            }
        }
    }
}

