/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.images;

import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.appwork.resources.HighDPIIcon;
import org.appwork.utils.images.AbstractIconPipe;
import org.appwork.utils.images.IconIO;
import org.appwork.utils.images.ModificationType;
import org.appwork.utils.swing.Graphics2DProxy;

public class ColoredIcon
extends AbstractIconPipe {
    private HashMap<ColorLookup, Color> colorMap = new HashMap();
    private BufferedImage cache;
    private double cachedScaleY;
    private double cachedScaleX;
    private static final Set<ModificationType> MODIFICATIONS = Collections.unmodifiableSet(new HashSet<ModificationType>(Arrays.asList(ModificationType.COLOR)));

    public ColoredIcon(Icon icon) {
        super(icon);
    }

    public ColoredIcon(Icon icon, Color color) {
        super(icon);
        this.replace(new ColorLookup(null, 0, true), color);
    }

    public ColoredIcon(Icon icon, ColorLookup from, Color to) {
        super(icon);
        this.replace(from, to);
    }

    public ColoredIcon replace(ColorLookup from, Color to) {
        this.colorMap.put(from, to);
        return this;
    }

    public ColoredIcon(Icon icon, Color from, Color to) {
        super(icon);
        this.replace(new ColorLookup(from, 50, true), to);
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.paintIcon(c, g, x, y, null);
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y, List<Icon> parents) {
        Graphics2D g2;
        AffineTransform transform = ((Graphics2D)g).getTransform();
        if (this.cache == null || this.cachedScaleX != transform.getScaleX() || this.cachedScaleY != transform.getScaleY()) {
            this.cache = IconIO.createEmptyImage((int)Math.round((double)this.getIconWidth() * transform.getScaleX()), (int)Math.round((double)this.getIconHeight() * transform.getScaleY()), 2, 3);
            this.cachedScaleX = transform.getScaleX();
            this.cachedScaleY = transform.getScaleY();
            g2 = this.cache.createGraphics();
            g2.scale(this.cachedScaleX, this.cachedScaleY);
            this.paintDelegate(c, new Graphics2DProxyImpl(g2, this), 0, 0, parents);
            g2.dispose();
        }
        g2 = (Graphics2D)g.create();
        g2.scale(1.0 / transform.getScaleX(), 1.0 / transform.getScaleY());
        new HighDPIIcon(this.cache).paintIcon(c, g2, (int)((double)x * this.cachedScaleX), (int)((double)y * this.cachedScaleY), parents);
        g2.dispose();
    }

    public String toString() {
        return "Colored Icon: " + this.getDelegate() + " " + this.getIconWidth() + ":" + this.getIconHeight();
    }

    public Color modifyColor(Color c) {
        Color replacement = null;
        int rgb = c.getRGB();
        int a = rgb >> 24 & 0xFF;
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb >> 0 & 0xFF;
        for (Map.Entry<ColorLookup, Color> es : this.colorMap.entrySet()) {
            if (es.getKey().color == null) {
                if (c == null || c.getAlpha() == 0) continue;
                return es.getValue();
            }
            Color replace = es.getValue();
            Color search = es.getKey().color;
            int a1 = search.getAlpha();
            int r1 = search.getRed();
            int g1 = search.getGreen();
            int b1 = search.getBlue();
            int tollerance = es.getKey().tollerance;
            boolean keepBrightness = es.getKey().keepBrightness;
            if (Math.abs(r - r1) <= tollerance && Math.abs(g - g1) <= tollerance && Math.abs(b - b1) <= tollerance && Math.abs(a - a1) <= tollerance) {
                if (!keepBrightness) {
                    return replace;
                }
                double brightness = (0.299 * (double)r + 0.578 * (double)g + 0.114 * (double)b) / 255.0;
                Color nc = new Color((int)((double)replace.getRed() * brightness), (int)((double)replace.getGreen() * brightness), (int)((double)replace.getBlue() * brightness), replace.getAlpha() * a / 255);
                return nc;
            }
            if (replacement == null) {
                replacement = this.colorMap.get(null);
            }
            if (replacement == null) continue;
            return replacement;
        }
        return c;
    }

    public Paint modifyPaint(Paint paint) {
        if (paint instanceof Color) {
            return this.modifyColor((Color)paint);
        }
        return paint;
    }

    @Override
    public Set<ModificationType> getModifications() {
        return MODIFICATIONS;
    }

    private class Graphics2DProxyImpl
    extends Graphics2DProxy {
        private ColoredIcon icon;

        public Graphics2DProxyImpl(Graphics2D g, ColoredIcon coloredIcon2) {
            super(g);
            this.icon = coloredIcon2;
        }

        @Override
        protected BufferedImage beforeBufferedImageDraw(BufferedImage img) {
            return IconIO.toBufferedImage(this.beforeImageDraw(img));
        }

        @Override
        protected Image beforeImageDraw(Image img) {
            Image ret = img;
            for (Map.Entry es : ColoredIcon.this.colorMap.entrySet()) {
                ret = IconIO.replaceColor(IconIO.toBufferedImage(ret), ((ColorLookup)es.getKey()).color, ((ColorLookup)es.getKey()).tollerance, (Color)es.getValue(), ((ColorLookup)es.getKey()).keepBrightness);
            }
            return ret;
        }

        @Override
        public void setComposite(Composite comp) {
            super.setComposite(comp);
        }

        @Override
        public void setPaint(Paint paint) {
            super.setPaint(this.icon.modifyPaint(paint));
        }

        @Override
        public void setColor(Color c) {
            super.setColor(this.icon.modifyColor(c));
        }

        @Override
        public Graphics create() {
            return new Graphics2DProxyImpl((Graphics2D)this.delegate.create(), this.icon);
        }

        @Override
        public Graphics create(int x, int y, int width, int height) {
            return new Graphics2DProxyImpl((Graphics2D)super.create(x, y, width, height), this.icon);
        }
    }

    public static class ColorLookup {
        private boolean keepBrightness = true;
        private Color color;
        private int tollerance = 0;

        public ColorLookup(Color search, int tollerance2, boolean keepBrightness) {
            this.color = search;
            this.tollerance = tollerance2;
            this.keepBrightness = keepBrightness;
        }
    }
}

