/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.images;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.appwork.resources.MultiResolutionImageHelper;
import org.appwork.utils.images.IconIO;
import org.appwork.utils.images.IconPipe;

public class IconDebugger
extends JFrame {
    private static IconDebugger instance;
    private JPanel container;
    private Map<String, DebugRow> entries;
    private JTextField searchField;

    private IconDebugger() {
        super("Icon Debugger");
        this.setLayout(new BorderLayout());
        JPanel searchPanel = new JPanel(new BorderLayout());
        JLabel searchLabel = new JLabel("Search: ");
        this.searchField = new JTextField();
        searchPanel.add((Component)searchLabel, "West");
        searchPanel.add((Component)this.searchField, "Center");
        this.add((Component)searchPanel, "North");
        this.container = new JPanel();
        this.container.setLayout(new BoxLayout(this.container, 1));
        this.entries = new HashMap<String, DebugRow>();
        JScrollPane scrollPane = new JScrollPane(this.container);
        scrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.add((Component)scrollPane, "Center");
        this.searchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                IconDebugger.this.filterRows(IconDebugger.this.searchField.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                IconDebugger.this.filterRows(IconDebugger.this.searchField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                IconDebugger.this.filterRows(IconDebugger.this.searchField.getText());
            }
        });
        this.setDefaultCloseOperation(1);
        this.setSize(600, 400);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void filterRows(String searchTerm) {
        String lowerTerm = searchTerm.toLowerCase();
        for (Map.Entry<String, DebugRow> entry : this.entries.entrySet()) {
            DebugRow row = entry.getValue();
            if (row.iconText.toLowerCase().contains(lowerTerm)) {
                row.panel.setVisible(true);
                continue;
            }
            row.panel.setVisible(false);
        }
        this.container.revalidate();
        this.container.repaint();
    }

    private void update(Icon icon, String text) {
        if (this.entries.containsKey(text)) {
            DebugRow row = this.entries.get(text);
            row.iconLabel.setNewIcon(icon);
            row.updateInfo(icon);
        } else {
            DebugRow row = new DebugRow(icon, text);
            this.container.add(row.panel);
            this.entries.put(text, row);
        }
        this.container.revalidate();
        this.container.repaint();
    }

    public static void show(Icon icon, String text) {
        if (instance == null) {
            instance = new IconDebugger();
        }
        instance.update(icon, text);
        if (!instance.isVisible()) {
            instance.setVisible(true);
        }
    }

    public static void show(Image image, String text) {
        IconDebugger.show(new WrappedImageIcon(image), text);
    }

    public static void show(Image ... images) {
        for (int i = 0; i < images.length; ++i) {
            IconDebugger.show(new WrappedImageIcon(images[i]), "Image " + (i + 1));
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Icon redIcon = IconDebugger.createIcon(Color.RED, 16, 16);
                Icon greenIcon = IconDebugger.createIcon(Color.GREEN, 32, 32);
                Icon blueIcon = IconDebugger.createIcon(Color.BLUE, 48, 48);
                IconDebugger.show(redIcon, "Test Icon");
                IconDebugger.show(greenIcon, "Another Icon");
                IconDebugger.show(blueIcon, "Test Icon");
                Image yellowImage = IconDebugger.createImage(Color.YELLOW, 64, 64);
                Image magentaImage = IconDebugger.createImage(Color.MAGENTA, 80, 80);
                IconDebugger.show(yellowImage, "Yellow Image");
                IconDebugger.show(magentaImage, "Magenta Image");
                IconDebugger.show(yellowImage, magentaImage);
            }
        });
    }

    private static Icon createIcon(Color color, int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g2 = image.createGraphics();
        g2.setColor(color);
        g2.fillRect(0, 0, width, height);
        g2.dispose();
        return new ImageIcon(image);
    }

    private static Image createImage(Color color, int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g2 = image.createGraphics();
        g2.setColor(color);
        g2.fillRect(0, 0, width, height);
        g2.dispose();
        return image;
    }

    private static class WrappedImageIcon
    extends ImageIcon {
        private final Image originalImage;

        public WrappedImageIcon(Image image) {
            super(image);
            this.originalImage = image;
        }

        public Image getOriginalImage() {
            return this.originalImage;
        }
    }

    private static class ZoomableIconLabel
    extends JLabel {
        private Icon originalIcon;
        private double zoomFactor = 1.0;
        private PixelInfoListener pixelInfoListener;

        public ZoomableIconLabel(Icon icon) {
            super(icon);
            this.setOpaque(false);
            this.setNewIcon(icon);
            this.setFocusable(true);
            this.addMouseWheelListener(new MouseWheelListener(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent e) {
                    if (ZoomableIconLabel.this.originalIcon == null) {
                        return;
                    }
                    int notches = e.getWheelRotation();
                    double newZoom = ZoomableIconLabel.this.zoomFactor - (double)notches * 0.1;
                    if (newZoom < 0.1) {
                        newZoom = 0.1;
                    }
                    ZoomableIconLabel.this.zoomFactor = newZoom;
                    ZoomableIconLabel.this.applyZoom();
                }
            });
            this.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    if (ZoomableIconLabel.this.originalIcon != null) {
                        String hex = ZoomableIconLabel.this.getPixelHexAt(e.getX(), e.getY());
                        if (ZoomableIconLabel.this.pixelInfoListener != null) {
                            ZoomableIconLabel.this.pixelInfoListener.pixelInfoUpdated(hex);
                        }
                    }
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    this.mouseMoved(e);
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (ZoomableIconLabel.this.originalIcon != null) {
                        String hex = ZoomableIconLabel.this.getPixelHexAt(e.getX(), e.getY());
                        if (ZoomableIconLabel.this.pixelInfoListener != null) {
                            ZoomableIconLabel.this.pixelInfoListener.pixelInfoFixed(hex);
                        }
                    }
                }
            });
        }

        public void setPixelInfoListener(PixelInfoListener listener) {
            this.pixelInfoListener = listener;
        }

        public void setNewIcon(Icon newIcon) {
            this.originalIcon = newIcon;
            this.applyZoom();
        }

        private String getPixelHexAt(int x, int y) {
            Image image = IconIO.toImage(this.getIcon());
            BufferedImage bimg = IconIO.toBufferedImage(image);
            if (x >= 0 && x < bimg.getWidth() && y >= 0 && y < bimg.getHeight()) {
                int pixel = bimg.getRGB(x, y);
                int alpha = pixel >> 24 & 0xFF;
                int red = pixel >> 16 & 0xFF;
                int green = pixel >> 8 & 0xFF;
                int blue = pixel & 0xFF;
                return String.format("#%02X%02X%02X%02X", alpha, red, green, blue);
            }
            return "Outside image bounds";
        }

        private void applyZoom() {
            int newWidth = (int)((double)this.originalIcon.getIconWidth() * this.zoomFactor);
            int newHeight = (int)((double)this.originalIcon.getIconHeight() * this.zoomFactor);
            this.setIcon(IconIO.getScaledInstance(this.originalIcon, newWidth, newHeight));
        }

        @Override
        protected void paintComponent(Graphics g) {
            int tileSize = 10;
            int width = this.getWidth();
            int height = this.getHeight();
            for (int y = 0; y < height; y += tileSize) {
                for (int x = 0; x < width; x += tileSize) {
                    boolean isLight = (x / tileSize + y / tileSize) % 2 == 0;
                    g.setColor(isLight ? Color.white : Color.lightGray);
                    g.fillRect(x, y, tileSize, tileSize);
                }
            }
            super.paintComponent(g);
        }
    }

    private static class DebugRow {
        public ZoomableIconLabel iconLabel;
        public JTextArea infoTextArea;
        public JPanel panel;
        private String iconText;
        private String baseInfo;
        private String temporaryPixelInfo = "";
        private StringBuilder fixedPixelInfos = new StringBuilder();

        public DebugRow(Icon icon, String text) {
            this.iconText = text;
            this.panel = new JPanel();
            this.panel.setLayout(new BoxLayout(this.panel, 0));
            this.iconLabel = new ZoomableIconLabel(icon);
            this.iconLabel.setAlignmentY(0.5f);
            this.iconLabel.setPixelInfoListener(new PixelInfoListener(){

                @Override
                public void pixelInfoUpdated(String infoLine) {
                    DebugRow.this.temporaryPixelInfo = infoLine;
                    DebugRow.this.updateInfoPanel();
                }

                @Override
                public void pixelInfoFixed(String infoLine) {
                    if (DebugRow.this.fixedPixelInfos.length() > 0) {
                        DebugRow.this.fixedPixelInfos.append(", ");
                    }
                    DebugRow.this.fixedPixelInfos.append(infoLine);
                    DebugRow.this.updateInfoPanel();
                }
            });
            this.baseInfo = this.buildInfo(icon);
            this.infoTextArea = new JTextArea();
            this.infoTextArea.setEditable(false);
            this.infoTextArea.setLineWrap(true);
            this.infoTextArea.setWrapStyleWord(true);
            this.infoTextArea.setFont(new Font("Monospaced", 0, 12));
            this.infoTextArea.setPreferredSize(new Dimension(250, 50));
            this.updateInfoPanel();
            this.panel.add(this.iconLabel);
            this.panel.add(Box.createRigidArea(new Dimension(10, 0)));
            this.panel.add(this.infoTextArea);
        }

        private void updateInfoPanel() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.iconText).append("\n");
            sb.append(this.baseInfo);
            if (this.fixedPixelInfos.length() > 0) {
                sb.append("\nFixed: ").append(this.fixedPixelInfos.toString());
            }
            if (!this.temporaryPixelInfo.isEmpty()) {
                sb.append("\nCurrent: ").append(this.temporaryPixelInfo);
            }
            this.infoTextArea.setText(sb.toString());
        }

        public void updateInfo(Icon icon) {
            this.baseInfo = this.buildInfo(icon);
            this.updateInfoPanel();
        }

        private String buildInfo(Icon icon) {
            StringBuilder sb = new StringBuilder();
            if (icon instanceof WrappedImageIcon) {
                Image orig = ((WrappedImageIcon)icon).getOriginalImage();
                sb.append("Type: ").append(orig.getClass().getSimpleName());
            } else {
                sb.append("Type: : ").append(icon.getClass().getSimpleName());
            }
            Icon entry = icon;
            while (entry instanceof IconPipe) {
                if ((entry = ((IconPipe)((Object)entry)).getDelegate()) == null) continue;
                if (entry.getClass().isAnonymousClass()) {
                    sb.append(" > ").append(entry.getClass().getSuperclass().getSimpleName());
                    continue;
                }
                sb.append(" > ").append(entry.getClass().getSimpleName());
            }
            sb.append(" | Dimensions: ").append(icon.getIconWidth()).append("x").append(icon.getIconHeight());
            if (icon instanceof ImageIcon) {
                Image image = ((ImageIcon)icon).getImage();
                try {
                    if (MultiResolutionImageHelper.isInstanceOf(image)) {
                        sb.append(" | MultiResolutionImage: yes");
                        List<Image> variants = MultiResolutionImageHelper.getResolutionVariants(image);
                        if (!variants.isEmpty()) {
                            sb.append(" | Variants:");
                            for (Image variant : variants) {
                                int w = new ImageIcon(variant).getIconWidth();
                                int h = new ImageIcon(variant).getIconHeight();
                                sb.append(" ").append(w).append("x").append(h).append(";");
                            }
                        }
                    } else {
                        sb.append(" | MultiResolutionImage: no");
                    }
                }
                catch (Exception e) {
                    sb.append(" | MultiResolutionImage: no");
                }
            }
            return sb.toString();
        }
    }

    private static interface PixelInfoListener {
        public void pixelInfoUpdated(String var1);

        public void pixelInfoFixed(String var1);
    }
}

