/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.images;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.GDI32;
import com.sun.jna.platform.win32.Shell32;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinGDI;
import com.sun.jna.platform.win32.WinNT;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import org.appwork.exceptions.WTFException;
import org.appwork.resources.MultiResolutionImageHelper;
import org.appwork.utils.Application;
import org.appwork.utils.IO;
import org.appwork.utils.images.IconIO;

public class JNAImageHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getImageFromExe(URL resource) throws IOException {
        File target = null;
        boolean deleteExe = false;
        try {
            BufferedImage largeImage;
            if (!"file".equals(resource.getProtocol().toLowerCase(Locale.ROOT))) {
                target = Application.getTempUniqueResource(".tmpexe");
                IO.writeToFile(target, IO.readURL(resource));
                deleteExe = true;
            } else {
                try {
                    target = new File(resource.toURI());
                }
                catch (URISyntaxException e) {
                    throw new WTFException(e);
                }
            }
            if (!target.isFile()) {
                Image e = null;
                return e;
            }
            boolean iconIndex = false;
            int totalIcons = Shell32.INSTANCE.ExtractIconEx(target.getAbsolutePath(), -1, null, null, 0);
            if (totalIcons == 0) {
                Image image = null;
                return image;
            }
            WinDef.HICON[] largeIcons = new WinDef.HICON[totalIcons];
            WinDef.HICON[] smallIcons = new WinDef.HICON[totalIcons];
            int numExtracted = Shell32.INSTANCE.ExtractIconEx(target.getAbsolutePath(), 0, largeIcons, smallIcons, totalIcons);
            if (numExtracted == 0) {
                Image image = null;
                return image;
            }
            ArrayList<Image> images = new ArrayList<Image>();
            for (WinDef.HICON i : largeIcons) {
                if (i == null) continue;
                try {
                    largeImage = JNAImageHelper.toImage(i);
                    if (largeImage == null) continue;
                    images.add(largeImage);
                }
                finally {
                    User32.INSTANCE.DestroyIcon(i);
                }
            }
            for (WinDef.HICON i : smallIcons) {
                if (i == null) continue;
                try {
                    largeImage = JNAImageHelper.toImage(i);
                    if (largeImage == null) continue;
                    images.add(largeImage);
                }
                finally {
                    User32.INSTANCE.DestroyIcon(i);
                }
            }
            MultiResolutionImageHelper.sortImagesBySize(images);
            if (images.size() == 0) {
                Image image = null;
                return image;
            }
            if (images.size() > 1 && MultiResolutionImageHelper.isSupported()) {
                Image image = MultiResolutionImageHelper.create(images.get(images.size() - 1), images);
                return image;
            }
            Image image = images.get(images.size() - 1);
            return image;
        }
        finally {
            if (deleteExe && target != null) {
                target.delete();
                target.deleteOnExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage toImage(WinDef.HICON hicon) {
        GDI32 gdi32;
        WinDef.HBITMAP bitmapHandle;
        block10: {
            WinGDI.ICONINFO info;
            User32 user32;
            block9: {
                BufferedImage bufferedImage;
                bitmapHandle = null;
                user32 = User32.INSTANCE;
                gdi32 = GDI32.INSTANCE;
                try {
                    info = new WinGDI.ICONINFO();
                    if (user32.GetIconInfo(hicon, info)) break block9;
                    bufferedImage = null;
                }
                catch (Throwable throwable) {
                    gdi32.DeleteObject((WinNT.HANDLE)hicon);
                    if (bitmapHandle != null) {
                        gdi32.DeleteObject(bitmapHandle);
                    }
                    throw throwable;
                }
                gdi32.DeleteObject((WinNT.HANDLE)hicon);
                if (bitmapHandle != null) {
                    gdi32.DeleteObject((WinNT.HANDLE)bitmapHandle);
                }
                return bufferedImage;
            }
            info.read();
            bitmapHandle = info.hbmColor != null ? info.hbmColor : info.hbmMask;
            WinGDI.BITMAP bitmap = new WinGDI.BITMAP();
            if (gdi32.GetObject((WinNT.HANDLE)bitmapHandle, bitmap.size(), bitmap.getPointer()) <= 0) break block10;
            bitmap.read();
            int width = bitmap.bmWidth.intValue();
            int height = bitmap.bmHeight.intValue();
            WinDef.HDC deviceContext = user32.GetDC(null);
            WinGDI.BITMAPINFO bitmapInfo = new WinGDI.BITMAPINFO();
            bitmapInfo.bmiHeader.biSize = bitmapInfo.bmiHeader.size();
            if (gdi32.GetDIBits(deviceContext, bitmapHandle, 0, 0, Pointer.NULL, bitmapInfo, 0) == 0) {
                throw new IllegalArgumentException("GetDIBits should not return 0");
            }
            bitmapInfo.read();
            Memory pixels = new Memory((long)bitmapInfo.bmiHeader.biSizeImage);
            bitmapInfo.bmiHeader.biCompression = 0;
            bitmapInfo.bmiHeader.biHeight = -height;
            if (gdi32.GetDIBits(deviceContext, bitmapHandle, 0, bitmapInfo.bmiHeader.biHeight, (Pointer)pixels, bitmapInfo, 0) == 0) {
                throw new IllegalArgumentException("GetDIBits should not return 0");
            }
            int[] colorArray = pixels.getIntArray(0L, width * height);
            BufferedImage image = IconIO.createEmptyImage(width, height);
            image.setRGB(0, 0, width, height, colorArray, 0, width);
            BufferedImage bufferedImage = image;
            gdi32.DeleteObject((WinNT.HANDLE)hicon);
            if (bitmapHandle != null) {
                gdi32.DeleteObject((WinNT.HANDLE)bitmapHandle);
            }
            return bufferedImage;
        }
        gdi32.DeleteObject((WinNT.HANDLE)hicon);
        if (bitmapHandle != null) {
            gdi32.DeleteObject((WinNT.HANDLE)bitmapHandle);
        }
        return null;
    }
}

