/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.io.streamingio;

import java.io.IOException;
import java.io.InputStream;
import org.appwork.utils.io.streamingio.Streaming;
import org.appwork.utils.io.streamingio.StreamingChunk;

public class StreamingInputStream
extends InputStream {
    public static final String DOWNLOAD_STREAM_IS_CLOSED = "DownloadStream is closed";
    protected final Streaming streaming;
    protected final long startPosition;
    protected final long endPosition;
    protected StreamingChunk currentChunk = null;
    protected byte[] singleReadBuffer = new byte[1];
    protected long currentPosition;

    protected StreamingInputStream(Streaming streaming, long startPosition, long endPosition) {
        this.streaming = streaming;
        this.startPosition = startPosition;
        this.endPosition = endPosition;
        this.currentPosition = startPosition;
    }

    protected int checkEOF(int wishedReadLength) {
        if (this.endPosition < 0L) {
            return wishedReadLength;
        }
        if ((wishedReadLength = Math.min(wishedReadLength, (int)(this.endPosition - this.currentPosition))) <= 0) {
            return -1;
        }
        return wishedReadLength;
    }

    @Override
    public void close() {
        this.streaming.closeInputStream(this);
    }

    protected StreamingChunk getCurrentChunk() {
        return this.currentChunk;
    }

    public long getCurrentPosition() {
        return this.currentPosition;
    }

    public long getEndPosition() {
        return this.endPosition;
    }

    public long getStartPosition() {
        return this.startPosition;
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        if (this.currentChunk == null) {
            throw new IOException("inputstream is closed");
        }
        int len = this.checkEOF(1);
        if (len == -1) {
            return -1;
        }
        int ret = this.streaming.readChunkData(this, this.singleReadBuffer, 0, len);
        if (ret == -1) {
            return -1;
        }
        if (ret == 1) {
            ++this.currentPosition;
            return this.singleReadBuffer[0];
        }
        throw new IOException("unknown IOException, ret=" + ret);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.currentChunk == null) {
            throw new IOException(DOWNLOAD_STREAM_IS_CLOSED);
        }
        if ((len = this.checkEOF(len)) == -1) {
            return -1;
        }
        int ret = this.streaming.readChunkData(this, b, off, len);
        if (ret == -1) {
            return -1;
        }
        this.currentPosition += (long)ret;
        return ret;
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    protected void setCurrentChunk(StreamingChunk currentChunk) {
        this.currentChunk = currentChunk;
    }
}

