/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.io.streamingio;

import java.io.IOException;
import java.io.OutputStream;
import org.appwork.utils.io.streamingio.Streaming;
import org.appwork.utils.io.streamingio.StreamingChunk;

public class StreamingOutputStream
extends OutputStream {
    protected Streaming streaming;
    protected byte[] singleWriteBuffer = new byte[1];
    protected StreamingChunk currentChunk = null;

    protected StreamingOutputStream(Streaming streaming) {
        this.streaming = streaming;
    }

    @Override
    public void close() {
        this.streaming.closeOutputStream(this);
    }

    @Override
    public void flush() throws IOException {
        StreamingChunk lcurrentChunk = this.currentChunk;
        if (lcurrentChunk == null) {
            throw new IOException("outputstream is closed!");
        }
        lcurrentChunk.sync();
    }

    protected StreamingChunk getCurrentChunk() {
        return this.currentChunk;
    }

    public void setCurrentChunk(StreamingChunk currentChunk) {
        this.currentChunk = currentChunk;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.currentChunk == null) {
            throw new IOException("outputstream is closed!");
        }
        this.streaming.writeChunkData(this, b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.currentChunk == null) {
            throw new IOException("outputstream is closed!");
        }
        this.singleWriteBuffer[0] = (byte)b;
        this.streaming.writeChunkData(this, this.singleWriteBuffer, 0, 1);
    }
}

