/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.logging2;

import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import org.appwork.utils.Exceptions;
import org.appwork.utils.StringBuilderQueue;

public class LogSourceFormatter
extends SimpleFormatter {
    private final Date dat = new Date();
    private final DateFormat longTimestamp = DateFormat.getDateTimeInstance(3, 2, Locale.ROOT);
    private int lastThreadID;
    protected StringBuilder formatterStringBuilder = null;

    @Override
    public synchronized String format(LogRecord record) {
        boolean sharedStringBuilder;
        StringBuilder sb = this.getFormatterStringBuilder();
        if (sb == null) {
            sharedStringBuilder = false;
            sb = new StringBuilder();
        } else {
            sharedStringBuilder = true;
        }
        StringBuilderQueue sbo = new StringBuilderQueue();
        this.dat.setTime(record.getMillis());
        String message = this.formatMessage(record);
        int th = record.getThreadID();
        if (th != this.lastThreadID) {
            sbo.append("------------------------Thread: ");
            sbo.append(th);
            sbo.append(":" + record.getLoggerName());
            sbo.append("-----------------------\r\n");
        }
        this.lastThreadID = th;
        sbo.append("--ID:" + th + "TS:" + record.getMillis() + "-");
        sbo.append(this.longTimestamp.format(this.dat));
        sbo.append(" - ");
        sbo.append(" [");
        String tmp = null;
        tmp = record.getSourceClassName();
        if (tmp != null) {
            sbo.append(tmp);
        }
        if ((tmp = record.getSourceMethodName()) != null) {
            sbo.append(Character.valueOf('('));
            sbo.append(tmp);
            sbo.append(Character.valueOf(')'));
        }
        sbo.append("] ");
        sbo.append("-> ");
        sbo.append(message);
        sbo.append("\r\n");
        if (record.getThrown() != null) {
            StringBuilder esb = new StringBuilder();
            Exceptions.getStackTrace(esb, record.getThrown());
            sbo.append(esb);
            sbo.append("\r\n");
        }
        sbo.flushToStringBuilder(sb);
        if (sharedStringBuilder) {
            return "";
        }
        return sb.toString();
    }

    public StringBuilder getFormatterStringBuilder() {
        return this.formatterStringBuilder;
    }

    public void setFormatterStringBuilder(StringBuilder formatterStringBuilder) {
        this.formatterStringBuilder = formatterStringBuilder;
    }
}

