/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class AutoWrapInflaterInputStream
extends FilterInputStream {
    public AutoWrapInflaterInputStream(InputStream inputStream) throws IOException {
        super(AutoWrapInflaterInputStream.autoWrap(inputStream));
    }

    public static InflaterInputStream autoWrap(InputStream inputStream) throws IOException {
        PushbackInputStream peekInputStream = new PushbackInputStream(inputStream, 2);
        byte[] zlibHeader = new byte[2];
        new DataInputStream(peekInputStream).readFully(zlibHeader);
        peekInputStream.unread(zlibHeader);
        int CMF = zlibHeader[0] & 0xFF;
        int CM = CMF & 0xF;
        int CINFO = CMF >> 4 & 0xF;
        int FLG = zlibHeader[1] & 0xFF;
        boolean FCHECK = (CMF << 8 | FLG) % 31 == 0;
        Inflater inflater = CM == 8 && CINFO <= 7 && FCHECK ? new Inflater(false) : new Inflater(true);
        return new InflaterInputStream(peekInputStream, inflater){
            private boolean closedFlag = false;

            @Override
            public void close() throws IOException {
                if (!this.closedFlag) {
                    try {
                        this.inf.end();
                    }
                    finally {
                        super.close();
                        this.closedFlag = true;
                    }
                }
            }
        };
    }
}

