/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class Base64InputStream
extends FilterInputStream {
    private static final char[] BASE64;
    private static final byte[] BASE64MAP;
    private final byte[] base64Encoded = new byte[4];
    private final byte[] base64Decoded = new byte[3];
    private int decodedAvailable = 0;
    private static final int LF = 10;
    private static final int CR = 13;
    private static final byte PADDING = 61;

    public Base64InputStream(InputStream in) {
        super(in);
    }

    @Override
    public int available() throws IOException {
        return this.in.available() * 3 / 4 + this.decodedAvailable;
    }

    private void decodeBase64() throws IOException {
        int next = -1;
        int encodedPosition = 0;
        this.decodedAvailable = 0;
        while (encodedPosition < 4 && (next = this.in.read()) >= 0) {
            if (next == 10 || next == 13) continue;
            this.base64Encoded[encodedPosition++] = (byte)next;
        }
        if (next == -1 && encodedPosition != 0) {
            throw new IOException("Base64 encoding error");
        }
        if (next == -1 && encodedPosition == 0) {
            return;
        }
        byte byte_part_1 = BASE64MAP[this.base64Encoded[0] & 0xFF];
        byte byte_part_2 = BASE64MAP[this.base64Encoded[1] & 0xFF];
        this.base64Decoded[this.decodedAvailable++] = (byte)(byte_part_1 << 2 & 0xFC | byte_part_2 >>> 4 & 3);
        if (this.base64Encoded[2] != 61) {
            byte_part_1 = byte_part_2;
            byte_part_2 = BASE64MAP[this.base64Encoded[2] & 0xFF];
            this.base64Decoded[this.decodedAvailable++] = (byte)(byte_part_1 << 4 & 0xF0 | byte_part_2 >>> 2 & 0xF);
            if (this.base64Encoded[3] != 61) {
                byte_part_1 = byte_part_2;
                byte_part_2 = BASE64MAP[this.base64Encoded[3] & 0xFF];
                this.base64Decoded[this.decodedAvailable++] = (byte)(byte_part_1 << 6 & 0xC0 | byte_part_2 & 0x3F);
            }
        }
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        int next = this.returnDecodedBase64();
        if (next >= 0) {
            return next;
        }
        this.decodeBase64();
        return this.returnDecodedBase64();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int c = this.read();
        if (c == -1) {
            return -1;
        }
        int index = 0;
        b[off + index++] = (byte)c;
        while (index < len && (c = this.read()) != -1) {
            b[off + index] = (byte)c;
            ++index;
        }
        return index;
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    private int returnDecodedBase64() {
        int next = -1;
        if (this.decodedAvailable > 0) {
            --this.decodedAvailable;
            next = this.base64Decoded[0] & 0xFF;
            this.base64Decoded[0] = this.base64Decoded[1];
            this.base64Decoded[1] = this.base64Decoded[2];
        }
        return next;
    }

    static {
        int i;
        BASE64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
        BASE64MAP = new byte[256];
        for (i = 0; i < 255; ++i) {
            Base64InputStream.BASE64MAP[i] = -1;
        }
        for (i = 0; i < BASE64.length; ++i) {
            Base64InputStream.BASE64MAP[Base64InputStream.BASE64[i]] = (byte)i;
        }
    }
}

