/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.appwork.utils.net.StreamValidEOF;

public class ChunkedInputStream
extends InputStream
implements StreamValidEOF {
    private final InputStream is;
    private volatile int nextChunkSize = 0;
    private volatile int nextChunkLeft = 0;
    private volatile long completeSize = 0L;
    private volatile boolean EOF = false;

    public ChunkedInputStream(InputStream is) {
        this.is = is;
    }

    @Override
    public int available() throws IOException {
        if (this.nextChunkLeft > 0) {
            return this.nextChunkLeft;
        }
        return this.is.available();
    }

    private int availableChunkData() throws IOException {
        if (this.nextChunkLeft == -1) {
            return -1;
        }
        if (this.nextChunkLeft > 0) {
            return this.nextChunkLeft;
        }
        StringBuilder sb = new StringBuilder();
        boolean chunkExt = false;
        byte[] b = new byte[]{0};
        int read = 0;
        if (this.nextChunkSize > 0 && (read = this.is.read()) == 13) {
            read = this.is.read();
        }
        read = this.is.read();
        while (read > -1 && read != 10 && read != 13) {
            if (read == 59) {
                chunkExt = true;
            }
            if (!chunkExt) {
                b[0] = (byte)(read & 0xFF);
                sb.append(new String(b, 0, 1));
            }
            read = this.is.read();
        }
        if (read == -1 && sb.length() == 0) {
            return -1;
        }
        if (read == 13) {
            read = this.is.read();
        }
        this.nextChunkSize = 0;
        if (sb.length() > 0) {
            try {
                this.nextChunkSize = Integer.parseInt(sb.toString().trim(), 16);
            }
            catch (NumberFormatException e) {
                throw new IOException(e);
            }
        }
        if (this.nextChunkSize == 0) {
            this.nextChunkLeft = -1;
            this.readTrailers();
        } else {
            this.completeSize += (long)this.nextChunkSize;
            this.nextChunkLeft = this.nextChunkSize;
        }
        return this.nextChunkLeft;
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    private void exhaustInputStream() throws IOException {
        int read = -1;
        boolean gotNL = false;
        while ((read = this.is.read()) >= 0) {
            if (gotNL) {
                if (read == 10) {
                    this.EOF = true;
                    return;
                }
                gotNL = false;
            }
            if (read != 13) continue;
            gotNL = true;
        }
    }

    public long getCompleteSize() {
        return this.completeSize;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        int left = this.availableChunkData();
        if (left > 0) {
            int ret = this.is.read();
            if (ret != -1) {
                --this.nextChunkLeft;
                return ret;
            }
            throw new EOFException("premature EOF");
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int left = this.availableChunkData();
        if (left > 0) {
            int ret = this.is.read(b, off, Math.min(left, len));
            if (ret != -1) {
                this.nextChunkLeft -= ret;
                return ret;
            }
            throw new EOFException("premature EOF");
        }
        return -1;
    }

    private void readTrailers() throws IOException {
        this.exhaustInputStream();
    }

    @Override
    public boolean isValidEOF() {
        return this.EOF;
    }
}

