/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.httpclient;

import org.appwork.utils.StringUtils;
import org.appwork.utils.net.httpclient.HttpClient;
import org.appwork.utils.net.httpclient.HttpClientException;
import org.appwork.utils.net.httpconnection.HTTPConnection;

public class InvalidResponseCode
extends HttpClientException {
    public final String message;

    public InvalidResponseCode(HttpClient.RequestContext context, String message) {
        super(context, null, "Invalid ResponseCode: " + context.getConnection().getResponseCode());
        this.message = message;
    }

    public InvalidResponseCode(HttpClient.RequestContext context, Throwable cause) {
        super(context, cause, "Invalid ResponseCode: " + context.getConnection().getResponseCode());
        this.message = null;
    }

    public InvalidResponseCode(HttpClient.RequestContext context) {
        super(context, null, "Invalid ResponseCode: " + context.getConnection().getResponseCode());
        this.message = null;
    }

    public String getRawMessage() {
        return this.message;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("Invalid ResponseCode: " + this.getCode());
        if (StringUtils.isNotEmpty(this.message)) {
            sb.append("\r\nResponseBody:\r\n").append(this.message);
        }
        return sb.toString();
    }

    public int getCode() {
        try {
            HTTPConnection connection = this.context.getConnection();
            return connection != null ? connection.getResponseCode() : -1;
        }
        catch (Exception e) {
            return -1;
        }
    }
}

