/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.httpconnection;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import org.appwork.utils.net.httpconnection.AbstractSocksHTTPConnection;
import org.appwork.utils.net.httpconnection.HTTPConnectionUtils;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.net.httpconnection.SocketStreamInterface;
import org.appwork.utils.net.socketconnection.Socks4SocketConnection;
import org.appwork.utils.net.socketconnection.SocksSocketConnection;

public class Socks4HTTPConnectionImpl
extends AbstractSocksHTTPConnection {
    public Socks4HTTPConnectionImpl(URL url, HTTPProxy proxy, SocksSocketConnection.DESTTYPE destType) {
        super(url, proxy, destType);
    }

    public Socks4HTTPConnectionImpl(URL url, HTTPProxy proxy) {
        super(url, proxy);
    }

    @Override
    protected Socket createRawConnectionSocket(InetAddress bindInetAddress) throws IOException {
        Socks4SocketConnection socket = this.buildSocksSocketConnection();
        socket.setSoTimeout(this.getReadTimeout());
        return socket;
    }

    @Override
    protected HTTPConnectionUtils.IPVERSION getEndPointIPVersion() {
        return HTTPConnectionUtils.IPVERSION.IPV4_ONLY;
    }

    @Override
    protected InetSocketAddress buildConnectEndPointSocketAddress(SocksSocketConnection socksSocketConnection) throws IOException {
        InetSocketAddress ret = super.buildConnectEndPointSocketAddress(socksSocketConnection);
        if (HTTPProxy.TYPE.SOCKS4.equals(this.getProxy().getType())) {
            if (ret.isUnresolved()) {
                throw new UnknownHostException("Socks4 only supports IPv4 but is not resolved(" + (Object)((Object)this.getEndPointIPVersion()) + "):" + this.getHostname());
            }
            if (!(ret.getAddress() instanceof Inet4Address)) {
                throw new UnknownHostException("Socks4 only supports IPv4 but is resolved IPv6(" + (Object)((Object)this.getEndPointIPVersion()) + "):" + this.getHostname());
            }
            return ret;
        }
        return ret;
    }

    @Override
    protected SocketStreamInterface connect(SocketStreamInterface socketStream) throws IOException {
        Socket socket = socketStream.getSocket();
        Socks4SocketConnection socks4Socket = (Socks4SocketConnection)socket;
        this.endPointInetSocketAddress = this.buildConnectEndPointSocketAddress(socks4Socket);
        socks4Socket.connect(this.endPointInetSocketAddress, this.getConnectTimeout(), this.proxyRequest);
        return socketStream;
    }

    @Override
    protected Socks4SocketConnection buildSocksSocketConnection() {
        Socks4SocketConnection socket = new Socks4SocketConnection(this.getProxy(), this.getDestType());
        return socket;
    }
}

