/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.net.httpserver.responses;

import java.io.IOException;
import java.io.OutputStream;
import org.appwork.net.protocol.http.HTTPConstants;
import org.appwork.net.protocol.http.ResponseCodeInterface;
import org.appwork.utils.net.HTTPHeader;
import org.appwork.utils.net.HeaderCollection;
import org.appwork.utils.net.httpserver.HttpConnection;
import org.appwork.utils.net.httpserver.RawHttpConnectionInterface;
import org.appwork.utils.net.httpserver.responses.HttpResponseInterface;

public class HttpResponse
implements HttpResponseInterface {
    private final HeaderCollection responseHeaders;
    public static final byte[] NEWLINE = "\r\n".getBytes();
    public static final byte[] HTTP11 = "HTTP/1.1 ".getBytes();
    public static final byte[] _0 = "0".getBytes();
    private ResponseCodeInterface responseCode = HTTPConstants.ResponseCode.SUCCESS_NO_CONTENT;
    protected final RawHttpConnectionInterface connection;
    protected OutputStream outputStream = null;
    protected boolean asyncResponse = false;

    public RawHttpConnectionInterface getConnection() {
        return this.connection;
    }

    public HttpResponse(RawHttpConnectionInterface connection) {
        this.connection = connection;
        this.responseHeaders = new HeaderCollection();
        this.responseHeaders.add(new HTTPHeader("Connection", "close"));
        this.responseHeaders.add(new HTTPHeader("Server", "AppWork GmbH HttpServer"));
    }

    @Override
    public void closeConnection() {
        try {
            this.connection.closeConnection();
        }
        finally {
            this.connection.close();
        }
    }

    @Override
    public OutputStream getOutputStream(boolean sendResponseHeaders) throws IOException {
        if (!sendResponseHeaders) {
            return this.connection.getOutputStream(false);
        }
        if (this.outputStream == null) {
            this.outputStream = this.connection.getOutputStream(true);
        }
        return this.outputStream;
    }

    @Override
    public ResponseCodeInterface getResponseCode() {
        return this.responseCode;
    }

    @Override
    public HeaderCollection getResponseHeaders() {
        return this.responseHeaders;
    }

    @Override
    public void setResponseCode(ResponseCodeInterface responseCode) {
        this.responseCode = responseCode;
    }

    public void setHook(HttpConnection.ConnectionHook hook) {
        this.connection.setHook(hook);
    }
}

