/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.os;

import org.appwork.utils.StringUtils;
import org.appwork.utils.os.CrossSystem;

public class Snap {
    private static final String SNAPINSTANCE = Snap.findSnapInstanceID();

    public static boolean isInsideSnap() {
        return Snap.getSnapInstanceName() != null;
    }

    public static String getSnapInstanceName() {
        return SNAPINSTANCE;
    }

    private static String findSnapInstanceID() {
        if (!CrossSystem.isUnix() || System.getenv("SNAP_COOKIE") == null) {
            return null;
        }
        String snapInstanceName = System.getenv("SNAP_INSTANCE_NAME");
        if (StringUtils.isNotEmpty(snapInstanceName)) {
            return snapInstanceName;
        }
        String snapName = System.getenv("SNAP_NAME");
        if (StringUtils.isNotEmpty(snapName)) {
            return snapName;
        }
        return null;
    }
}

