/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.processes;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import org.appwork.loggingv3.LogV3;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.processes.ProcessHandler;
import org.appwork.utils.processes.ProcessOutput;
import org.appwork.utils.processes.command.ProcessErrorStream;
import org.appwork.utils.processes.command.ProcessInputStream;
import org.appwork.utils.processes.command.ProcessStreamReader;

public class ProcessBuilderFactory {
    private static String CONSOLE_CODEPAGE = null;

    public static ProcessOutput runCommand(List<String> commands) throws IOException, InterruptedException {
        return ProcessBuilderFactory.runCommand(ProcessBuilderFactory.create(commands));
    }

    public static ProcessOutput runCommand(String ... commands) throws IOException, InterruptedException {
        return ProcessBuilderFactory.runCommand(ProcessBuilderFactory.create(commands));
    }

    public static ProcessOutput runCommand(ProcessBuilder pb) throws IOException, InterruptedException {
        ByteArrayOutputStream errorStream = new ByteArrayOutputStream();
        ByteArrayOutputStream sdtStream = new ByteArrayOutputStream();
        int exitCode = ProcessBuilderFactory.runCommand(pb, errorStream, sdtStream);
        return new ProcessOutput(exitCode, sdtStream, errorStream, ProcessBuilderFactory.getConsoleCodepage());
    }

    public static int runCommand(ProcessBuilder pb, OutputStream errorStream, OutputStream sdtStream) throws IOException, InterruptedException {
        return ProcessBuilderFactory.runCommand(pb, errorStream, sdtStream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int runCommand(ProcessBuilder pb, OutputStream errorStream, OutputStream sdtStream, ProcessHandler osHandler) throws IOException, InterruptedException {
        Thread stdReader = null;
        Thread errorReader = null;
        LogV3.info("runCommand:Command=" + pb.command() + "|Directory=" + pb.directory());
        Process process = pb.start();
        try {
            if (osHandler == null || !osHandler.setProcess(process)) {
                process.getOutputStream().close();
            }
            stdReader = new ProcessStreamReader("Process-Reader-Std:" + pb.command(), process, new ProcessInputStream(process), sdtStream);
            errorReader = new ProcessStreamReader("Process-Reader-Error:" + pb.command(), process, new ProcessErrorStream(process), errorStream);
            if (CrossSystem.isWindows()) {
                stdReader.setPriority(6);
                errorReader.setPriority(6);
            }
            stdReader.start();
            errorReader.start();
            int returnCode = process.waitFor();
            ((ProcessStreamReader)stdReader).waitFor();
            ((ProcessStreamReader)errorReader).waitFor();
            int n = returnCode;
            return n;
        }
        finally {
            try {
                errorStream.close();
            }
            catch (Throwable throwable) {}
            try {
                sdtStream.close();
            }
            catch (Throwable throwable) {}
            try {
                process.destroy();
            }
            catch (Throwable throwable) {}
            if (errorReader.isAlive()) {
                ((ProcessStreamReader)errorReader).notifyProcessExited();
                ((ProcessStreamReader)errorReader).interrupt();
            }
            if (stdReader.isAlive()) {
                ((ProcessStreamReader)stdReader).notifyProcessExited();
                ((ProcessStreamReader)stdReader).interrupt();
            }
        }
    }

    public static ProcessBuilder create(List<String> splitCommandString) {
        return ProcessBuilderFactory.create(splitCommandString.toArray(new String[0]));
    }

    public static ProcessBuilder create(String ... tiny) {
        return new ProcessBuilder(ProcessBuilderFactory.escape(tiny));
    }

    public static String[] escape(String[] input) {
        return ProcessBuilderFactory.escape(input, false);
    }

    public static String[] escape(String[] input, boolean forceEscape) {
        if (input != null && (CrossSystem.isWindows() || CrossSystem.isOS2() || forceEscape)) {
            String[] ret = new String[input.length];
            String rawC = "\"";
            String escapedC = "\\\"";
            for (int index = 0; index < ret.length; ++index) {
                boolean rawC_End;
                String value = input[index];
                if (value == null) {
                    ret[index] = value;
                    continue;
                }
                int count = new Regex(value, "((?<!\\\\)\")").count();
                boolean rawC_Start = value.startsWith("\"");
                boolean bl = rawC_End = value.endsWith("\"") && !value.endsWith("\\\"");
                if (count == 0) {
                    ret[index] = value;
                    continue;
                }
                if (rawC_Start && rawC_End) {
                    if (count % 2 == 0) {
                        ret[index] = value;
                        continue;
                    }
                    ret[index] = value;
                    continue;
                }
                ret[index] = count % 2 == 0 ? value : (rawC_Start && !rawC_End ? value + "\"" : (!rawC_Start && rawC_End ? "\"" + value : value));
            }
            return ret;
        }
        return input;
    }

    /*
     * Unable to fully structure code
     */
    public static String getConsoleCodepage() throws InterruptedException {
        if (StringUtils.isEmpty(ProcessBuilderFactory.CONSOLE_CODEPAGE)) {
            switch (2.$SwitchMap$org$appwork$utils$os$CrossSystem$OSFamily[CrossSystem.getOSFamily().ordinal()]) {
                case 1: {
                    return System.getProperty("file.encoding");
                }
                case 2: {
                    pb = ProcessBuilderFactory.create(new String[]{"cmd", "/c", "chcp"});
                    try {
                        LogV3.info("getConsoleCodepage:Command=" + pb.command() + "|Directory=" + pb.directory());
                        process = pb.start();
                        th = new Thread(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                try {
                                    String line;
                                    process.getOutputStream().close();
                                    BufferedReader f = new BufferedReader(new InputStreamReader(process.getInputStream(), "ASCII"));
                                    StringBuilder ret = new StringBuilder();
                                    String sep = System.getProperty("line.separator");
                                    while ((line = f.readLine()) != null) {
                                        if (Thread.interrupted()) {
                                            return;
                                        }
                                        if (ret.length() > 0) {
                                            ret.append(sep);
                                        } else if (line.startsWith("\ufeff")) {
                                            line = line.substring(1);
                                        }
                                        ret.append(line);
                                    }
                                    process.destroy();
                                    String result = ret.toString();
                                    result = new Regex(result, ":\\s*(\\d+)").getMatch(0);
                                    if (StringUtils.isNotEmpty(result)) {
                                        String cp = "cp" + result.trim();
                                        if ("CP65001".equalsIgnoreCase(cp)) {
                                            CONSOLE_CODEPAGE = "UTF-8";
                                        } else {
                                            CONSOLE_CODEPAGE = cp;
                                        }
                                    }
                                }
                                catch (Throwable e) {
                                    LogV3.log(e);
                                }
                                finally {
                                    try {
                                        process.destroy();
                                    }
                                    catch (Throwable throwable) {}
                                }
                            }
                        };
                        th.start();
                        try {
                            th.join();
                            ** break;
                        }
                        catch (InterruptedException e) {
                            try {
                                process.destroy();
                            }
                            catch (Throwable var4_5) {
                                // empty catch block
                            }
                            throw e;
lbl22:
                            // 1 sources

                        }
                    }
                    catch (IOException e1) {
                        LogV3.log(e1);
                    }
                    break;
                }
            }
            LogV3.info("Console Codepage: " + ProcessBuilderFactory.CONSOLE_CODEPAGE + "(" + Charset.defaultCharset().displayName() + ")");
            if (StringUtils.isEmpty(ProcessBuilderFactory.CONSOLE_CODEPAGE)) {
                ProcessBuilderFactory.CONSOLE_CODEPAGE = Charset.defaultCharset().displayName();
            }
        }
        return ProcessBuilderFactory.CONSOLE_CODEPAGE;
    }
}

