/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.processes.command;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.appwork.utils.net.LineParsingInputStream;
import org.appwork.utils.net.LineParsingOutputStream;
import org.appwork.utils.net.NullOutputStream;
import org.appwork.utils.processes.LineHandler;
import org.appwork.utils.processes.command.AsyncInputStreamHandler;
import org.appwork.utils.processes.command.OutputHandler;
import org.appwork.utils.processes.command.ProcessErrorStream;
import org.appwork.utils.processes.command.ProcessInputStream;
import org.appwork.utils.processes.command.ProcessStreamReader;

public abstract class AbstractLineHandler
implements LineHandler,
OutputHandler {
    protected int getLineReaderBufferSize() {
        return 8192;
    }

    protected boolean killProcessInFinally(ProcessStreamReader streamReader, Exception e) {
        return false;
    }

    protected boolean ignoreOutputStreamException(ProcessStreamReader streamReader, IOException e) {
        return true;
    }

    @Override
    public void onExitCode(int exitCode) {
    }

    protected LineParsingInputStream createLineParsingInputStream(InputStream inputStream, Charset charset) throws UnsupportedEncodingException {
        return new LineParser(inputStream, charset, inputStream);
    }

    protected int splitLine(StringBuilder sb) {
        return 0;
    }

    @Override
    public AsyncInputStreamHandler createAsyncStreamHandler(ProcessInputStream inputStream, Charset charset) throws UnsupportedEncodingException, InterruptedException {
        LineParsingInputStream is = this.createLineParsingInputStream(inputStream, charset);
        Process process = inputStream.getProcess();
        return new ProcessStreamReader("Line-Reader-Std:" + process, process, is, new NullOutputStream()){

            @Override
            protected int getReadBufferSize() {
                return AbstractLineHandler.this.getLineReaderBufferSize();
            }

            @Override
            protected boolean ignoreOutputStreamException(IOException e) {
                return AbstractLineHandler.this.ignoreOutputStreamException(this, e);
            }

            @Override
            protected boolean killProcessInFinally(Exception e) {
                return AbstractLineHandler.this.killProcessInFinally(this, e);
            }
        };
    }

    @Override
    public AsyncInputStreamHandler createAsyncStreamHandler(ProcessErrorStream inputStream, Charset charset) throws UnsupportedEncodingException, InterruptedException {
        LineParsingInputStream is = this.createLineParsingInputStream(inputStream, charset);
        Process process = inputStream.getProcess();
        return new ProcessStreamReader("Line-Reader-Error:" + process, process, is, new NullOutputStream()){

            @Override
            protected int getReadBufferSize() {
                return AbstractLineHandler.this.getLineReaderBufferSize();
            }

            @Override
            protected boolean ignoreOutputStreamException(IOException e) {
                return AbstractLineHandler.this.ignoreOutputStreamException(this, e);
            }

            @Override
            protected boolean killProcessInFinally(Exception e) {
                return AbstractLineHandler.this.killProcessInFinally(this, e);
            }
        };
    }

    private final class LineParser
    extends LineParsingInputStream {
        private final InputStream inputStream;

        private LineParser(InputStream is, Charset charset, InputStream inputStream) {
            super(is, charset);
            this.inputStream = inputStream;
        }

        @Override
        protected void onNextLine(LineParsingOutputStream.NEWLINE newLine, long line, StringBuilder sb, int startIndex, int endIndex) {
            AbstractLineHandler.this.handleLine(sb.substring(startIndex, endIndex), this.inputStream);
        }

        @Override
        protected LineParsingOutputStream createOutputStream(Charset charset, int bufferSize) {
            return new LineParsingOutputStream(charset, bufferSize){

                @Override
                protected void onNextLine(LineParsingOutputStream.NEWLINE newLine, long line, StringBuilder sb, int startIndex, int endIndex) {
                    LineParser.this.onNextLine(newLine, line, sb, startIndex, endIndex);
                }

                @Override
                protected int split(StringBuilder sb) {
                    return AbstractLineHandler.this.splitLine(sb);
                }
            };
        }
    }
}

