/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.processes.command;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.appwork.loggingv3.LogV3;
import org.appwork.utils.Time;
import org.appwork.utils.processes.ProcessBuilderFactory;
import org.appwork.utils.processes.command.AsyncInputStreamHandler;

public class ProcessStreamReader
extends Thread
implements AsyncInputStreamHandler {
    protected final Process process;
    protected final InputStream is;
    protected final OutputStream os;
    protected final AtomicBoolean processExitedFlag = new AtomicBoolean(false);
    protected volatile long processReadCurrent = 0L;

    public Process getProcess() {
        return this.process;
    }

    public InputStream getInputStream() {
        return this.is;
    }

    public OutputStream getOutputStream() {
        return this.os;
    }

    public ProcessStreamReader(String name, Process process, InputStream input, OutputStream output) {
        super(name);
        this.process = process;
        this.is = input;
        this.os = output;
        this.setDaemon(true);
        new Thread("ProcessStreamReaderWaitFor:" + process){
            {
                this.setDaemon(true);
            }

            @Override
            public void run() {
                try {
                    int exitCode = ProcessStreamReader.this.getProcess().waitFor();
                    ProcessStreamReader.this.onExit(exitCode);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }.start();
    }

    protected int getReadBufferSize() {
        return 8192;
    }

    protected boolean isProcessAlive() {
        if (this.processExitedFlag.get()) {
            return false;
        }
        try {
            this.getProcess().exitValue();
            this.notifyProcessExited();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        Exception thrown = null;
        try {
            byte[] buf = new byte[this.getReadBufferSize()];
            while (true) {
                int available;
                try {
                    while ((available = this.is.available()) <= 0 && !this.processExitedFlag.get()) {
                        AtomicBoolean atomicBoolean = this.processExitedFlag;
                        // MONITORENTER : atomicBoolean
                        this.processExitedFlag.wait(10L);
                        // MONITOREXIT : atomicBoolean
                    }
                }
                catch (IOException e) {
                    if (!this.isProcessAlive()) return;
                    LogV3.logger(ProcessBuilderFactory.class).log(e);
                    thrown = e;
                    return;
                }
                catch (InterruptedException e) {
                    thrown = e;
                    return;
                }
                try {
                    int read = available <= 0 && this.processExitedFlag.get() ? -1 : this.is.read(buf, 0, Math.min(buf.length, available));
                    if (read <= 0 && this.processExitedFlag.get()) {
                        return;
                    }
                    this.processReadCurrent += (long)read;
                    try {
                        this.os.write(buf, 0, read);
                        continue;
                    }
                    catch (IOException e) {
                        if (!this.ignoreOutputStreamException(e)) throw e;
                        continue;
                    }
                }
                catch (IOException e) {
                    if (!this.processExitedFlag.get()) {
                        LogV3.logger(ProcessBuilderFactory.class).log(e);
                    }
                    thrown = e;
                    return;
                }
                break;
            }
        }
        finally {
            if (this.killProcessInFinally(thrown)) {
                try {
                    this.process.exitValue();
                }
                catch (IllegalThreadStateException e2) {
                    this.process.destroy();
                }
            }
        }
    }

    protected boolean ignoreOutputStreamException(IOException e) {
        return false;
    }

    protected boolean killProcessInFinally(Exception e) {
        return true;
    }

    @Override
    public void interrupt() {
        try {
            try {
                this.is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            super.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyProcessExited() {
        if (this.processExitedFlag.compareAndSet(false, true)) {
            AtomicBoolean atomicBoolean = this.processExitedFlag;
            synchronized (atomicBoolean) {
                this.processExitedFlag.notifyAll();
            }
        }
    }

    protected long getProcessRead() {
        return this.processReadCurrent;
    }

    protected int getMaxWaitFor() {
        return 10000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitFor() throws InterruptedException {
        this.notifyProcessExited();
        long processReadLast = this.getProcessRead();
        long timeStamp = Time.systemIndependentCurrentJVMTimeMillis();
        try {
            while (this.isAlive()) {
                long now = this.getProcessRead();
                if (processReadLast == now) {
                    if (Time.systemIndependentCurrentJVMTimeMillis() - timeStamp > (long)this.getMaxWaitFor()) {
                        break;
                    }
                } else {
                    processReadLast = now;
                    timeStamp = Time.systemIndependentCurrentJVMTimeMillis();
                }
                Thread.sleep(50L);
            }
        }
        finally {
            this.interrupt();
        }
    }

    @Override
    public void onExit(int exitCode) {
        this.notifyProcessExited();
    }
}

