/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.reflection.tests;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.appwork.moncompare.Condition;
import org.appwork.storage.TypeRef;
import org.appwork.storage.simplejson.MinimalMemoryMap;
import org.appwork.storage.simplejson.mapper.ClassCache;
import org.appwork.testframework.AWTest;
import org.appwork.txtresource.LocaleMap;
import org.appwork.utils.KeyValueEntry;
import org.appwork.utils.KeyValueStringEntry;
import org.appwork.utils.reflection.CompiledType;
import org.appwork.utils.reflection.tests.A;
import org.appwork.utils.reflection.tests.ExtendedArrayList;
import org.appwork.utils.reflection.tests.ExtendedHashSet;
import org.appwork.utils.reflection.tests.ReGenericExtendsMap;
import org.appwork.utils.reflection.tests.ReReGenericDefinition;

public class CompiledTypeTests<T>
extends AWTest {
    @Override
    public void runTest() throws Exception {
        ClassCache cc = ClassCache.getClassCache(A.class);
        CompiledTypeTests.assertTrue(cc.getAllGetter().size() == 1);
        CompiledType.ToStringRule javaRule = new CompiledType.ToStringRule(CompiledType.ToStringSyntax.JAVA);
        CompiledType.ToStringRule jsonRule = new CompiledType.ToStringRule(CompiledType.ToStringSyntax.JSON);
        CompiledTypeTests.assertEquals("Array<Condition<Object>>", CompiledType.create(new TypeRef<ArrayList<Condition<Object>>>(){}.getType()).toString(new CompiledType.ToStringRule(CompiledType.ToStringSyntax.JSON)));
        CompiledType ct = CompiledType.create(Condition.class);
        CompiledTypeTests.assertEquals("Condition<Object>", ct.toString(javaRule));
        CompiledTypeTests.assertEquals("Condition<Object>", ct.toString(jsonRule));
        ct = CompiledType.create(MyEnum.class);
        CompiledTypeTests.assertTrue(ct.componentTypes.length == 0);
        CompiledTypeTests.assertEquals("MyEnum", ct.toString(javaRule));
        ct = CompiledType.create(new CompiledTypeTests(){}.getClass());
        CompiledTypeTests.assertEquals("", ct.toString(null));
        CompiledTypeTests.assertEquals("CompiledTypeTests<Object>", ct.toString(new CompiledType.ToStringRule().skipAnonymousClasses(true)));
        ct = CompiledType.create(int[].class);
        CompiledTypeTests.assertEquals("Array<int>", ct.toString(jsonRule));
        CompiledTypeTests.assertEquals("int[]", ct.toString(javaRule));
        CompiledTypeTests.assertEquals("Array<Integer>", ct.toString(new CompiledType.ToStringRule().primitiveWrapperStrategy(CompiledType.PrimitiveWrapperStrategy.WRAPPER_NAMES_FOR_BOTH)));
        CompiledTypeTests.assertEquals("Array<int>", ct.toString(new CompiledType.ToStringRule().primitiveWrapperStrategy(CompiledType.PrimitiveWrapperStrategy.DEDICATED_NAME_FOR_EACH)));
        ct = CompiledType.create(Integer[].class);
        CompiledTypeTests.assertEquals("Array<Integer>", ct.toString(jsonRule));
        CompiledTypeTests.assertEquals("Integer[]", ct.toString(javaRule));
        CompiledTypeTests.assertEquals("Array<int>", ct.toString(new CompiledType.ToStringRule().primitiveWrapperStrategy(CompiledType.PrimitiveWrapperStrategy.PRIMITIVE_NAMES_FOR_BOTH)));
        CompiledTypeTests.assertEquals("Array<Integer>", ct.toString(new CompiledType.ToStringRule().primitiveWrapperStrategy(CompiledType.PrimitiveWrapperStrategy.WRAPPER_NAMES_FOR_BOTH)));
        CompiledTypeTests.assertEquals("Array<Integer>", ct.toString(new CompiledType.ToStringRule().primitiveWrapperStrategy(CompiledType.PrimitiveWrapperStrategy.DEDICATED_NAME_FOR_EACH)));
        CompiledTypeTests.assertEquals("Array<KeyValueStringEntry>", CompiledType.create(KeyValueStringEntry[].class).toString(new CompiledType.ToStringRule().primitiveWrapperStrategy(CompiledType.PrimitiveWrapperStrategy.DEDICATED_NAME_FOR_EACH)));
        ct = CompiledType.create(new TypeRef<KeyValueEntry<String, String>[]>(){}.getType());
        CompiledTypeTests.assertEquals("Array<KeyValueEntry<String,String>>", ct.toString(null));
        CompiledTypeTests.assertTrue(ct.isGenericsResolved());
        ct = CompiledType.create(new TypeRef<KeyValueEntry<String, ?>[]>(){}.getType());
        CompiledTypeTests.assertFalse(ct.isGenericsResolved());
        CompiledTypeTests.assertEquals("Array<KeyValueEntry<String,?>>", ct.toString());
        ct = CompiledType.create(new TypeRef<KeyValueEntry<String, ? extends String>[]>(){}.getType());
        CompiledTypeTests.assertFalse(ct.isGenericsResolved());
        CompiledTypeTests.assertEquals("Array<KeyValueEntry<String,? extends String>>", ct.toString());
        ct = CompiledType.create(new TypeRef<KeyValueEntry<String, T>[]>(){}.getType());
        String name = ct.toString();
        CompiledTypeTests.assertFalse(ct.isGenericsResolved());
        CompiledTypeTests.assertEquals("Array<KeyValueEntry<String,T>>", name);
        ct = CompiledType.create(new TypeRef<KeyValueEntry<String, T>[]>(){}.getType(), new TypeRef<CompiledTypeTests<CompiledType>>(){}.getType());
        CompiledType ct2 = CompiledType.create(new TypeRef<KeyValueEntry<String, T>[]>(){}.getType(), new TypeRef<CompiledTypeTests<CompiledType>>(){}.getType());
        CompiledType ct3 = CompiledType.create(new TypeRef<KeyValueEntry<String, T>[]>(){}.getType(), new TypeRef<CompiledTypeTests<Object>>(){}.getType());
        CompiledTypeTests.assertEquals(ct, ct2);
        CompiledTypeTests.assertEqualsNot(ct, ct3);
        name = ct.toString();
        CompiledTypeTests.assertTrue(ct.isGenericsResolved());
        CompiledTypeTests.assertEquals("Array<KeyValueEntry<String,CompiledType>>", name);
        name = ct.toString(javaRule);
        CompiledTypeTests.assertEquals("KeyValueEntry<String,CompiledType>[]", name);
        ct = CompiledType.create(new TypeRef<CopyOnWriteArrayList<String>[]>(){}.getType());
        CompiledTypeTests.assertEquals("Array<Array<String>>", ct.toString(jsonRule));
        CompiledTypeTests.assertEquals("CopyOnWriteArrayList<String>[]", ct.toString(javaRule));
        ct = CompiledType.create(new TypeRef<ArrayList<String>[]>(){}.getType());
        CompiledTypeTests.assertEquals("Array<Array<String>>", ct.toString(jsonRule));
        CompiledTypeTests.assertEquals("ArrayList<String>[]", ct.toString(javaRule));
        ct = CompiledType.create(new TypeRef<LinkedList<String>>(){}.getType());
        CompiledTypeTests.assertEquals("Array<String>", ct.toString(jsonRule));
        CompiledTypeTests.assertEquals("LinkedList<String>", ct.toString(javaRule));
        ct = CompiledType.create(new TypeRef<MinimalMemoryMap<String, Integer>>(){}.getType());
        CompiledTypeTests.assertEquals("Map<String,Integer>", ct.toString(jsonRule));
        CompiledTypeTests.assertEquals("MinimalMemoryMap<String,Integer>", ct.toString(javaRule));
        ct = CompiledType.create(new TypeRef<HashMap<String, Integer>>(){}.getType());
        CompiledTypeTests.assertEquals("Map<String,Integer>", ct.toString(jsonRule));
        CompiledTypeTests.assertEquals("HashMap<String,Integer>", ct.toString(javaRule));
        ct = CompiledType.create(new TypeRef<LinkedHashMap<String, Integer>>(){}.getType());
        CompiledTypeTests.assertEquals("Map<String,Integer>", ct.toString(jsonRule));
        CompiledTypeTests.assertEquals("LinkedHashMap<String,Integer>", ct.toString(javaRule));
        ct = CompiledType.create(new TypeRef<HashSet<String>>(){}.getType());
        CompiledTypeTests.assertEquals("Array<String>", ct.toString(jsonRule));
        CompiledTypeTests.assertEquals("HashSet<String>", ct.toString(javaRule));
        ct = CompiledType.create(new TypeRef<CopyOnWriteArraySet<String>>(){}.getType());
        CompiledTypeTests.assertEquals("Array<String>", ct.toString(jsonRule));
        CompiledTypeTests.assertEquals("CopyOnWriteArraySet<String>", ct.toString(javaRule));
        ct = CompiledType.create(new TypeRef<LocaleMap>(){}.getType());
        CompiledTypeTests.assertEquals("LocaleMap", ct.toString(jsonRule));
        CompiledTypeTests.assertEquals("LocaleMap", ct.toString(javaRule));
        ct = CompiledType.create(new TypeRef<ExtendedArrayList>(){}.getType());
        CompiledTypeTests.assertEquals("Array<String>", ct.toString(jsonRule));
        CompiledTypeTests.assertEquals("ExtendedArrayList", ct.toString(javaRule));
        ct = CompiledType.create(new TypeRef<ExtendedHashSet>(){}.getType());
        CompiledTypeTests.assertEquals("Array<String>", ct.toString(jsonRule));
        CompiledTypeTests.assertEquals("ExtendedHashSet", ct.toString(javaRule));
        ct = CompiledType.create(new TypeRef<ReGenericExtendsMap<Integer, Long>>(){}.getType());
        CompiledTypeTests.assertEquals("ReGenericExtendsMap<Integer,Long>", ct.toString(jsonRule));
        CompiledTypeTests.assertEquals("ReGenericExtendsMap<Integer,Long>", ct.toString(javaRule));
        ct = CompiledType.create(new TypeRef<ReReGenericDefinition>(){}.getType());
        CompiledTypeTests.assertEquals("ReReGenericDefinition", ct.toString(jsonRule));
        CompiledTypeTests.assertEquals("ReReGenericDefinition", ct.toString(javaRule));
    }

    public static void main(String[] args) {
        CompiledTypeTests.run();
    }

    public static enum MyEnum {
        A,
        B;

    }
}

