/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class FocusPolicy
extends FocusTraversalPolicy {
    private List<JComponent> order;

    public FocusPolicy(JComponent ... components) {
        this.order = new ArrayList<JComponent>(components.length);
        for (JComponent c : components) {
            this.order.add(c);
        }
    }

    @Override
    public JComponent getComponentAfter(Container focusCycleRoot, Component aJComponent) {
        int idx = (this.order.indexOf(aJComponent) + 1) % this.order.size();
        return this.order.get(idx);
    }

    @Override
    public JComponent getComponentBefore(Container focusCycleRoot, Component aJComponent) {
        int idx = this.order.indexOf(aJComponent) - 1;
        if (idx < 0) {
            idx = this.order.size() - 1;
        }
        return this.order.get(idx);
    }

    @Override
    public JComponent getDefaultComponent(Container focusCycleRoot) {
        return this.order.get(0);
    }

    @Override
    public JComponent getLastComponent(Container focusCycleRoot) {
        return this.order.get(this.order.size() - 1);
    }

    @Override
    public JComponent getFirstComponent(Container focusCycleRoot) {
        return this.order.get(0);
    }
}

