/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.utils.swing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.appwork.loggingv3.LogV3;
import org.appwork.utils.swing.EDTHelper;

public class TreeModelStateSaver {
    protected JTree tree;
    private final HashMap<Object, Boolean> expandCache;
    private TreePath treePath;
    protected TreePath[] selectedPaths;

    public TreeModelStateSaver(JTree tree) {
        this.tree = tree;
        this.expandCache = new HashMap();
    }

    public HashMap<Object, Boolean> getExpandCache() {
        return this.expandCache;
    }

    public TreePath[] getSelectedPaths() {
        return this.selectedPaths;
    }

    public void restore() {
        new EDTHelper<Object>(){

            @Override
            public Object edtRun() {
                try {
                    if (TreeModelStateSaver.this.tree.getModel() == null) {
                        return null;
                    }
                    TreeModelStateSaver.this.restoreState(TreeModelStateSaver.this.tree.getModel().getRoot(), new ArrayList<Object>());
                    TreePath[] selectedPathes = TreeModelStateSaver.this.getSelectedPaths();
                    if (selectedPathes != null && selectedPathes.length > 0) {
                        TreeModelStateSaver.this.tree.getSelectionModel().clearSelection();
                        TreeModelStateSaver.this.tree.getSelectionModel().setSelectionPaths(selectedPathes);
                    }
                }
                catch (Throwable e) {
                    LogV3.log(e);
                }
                return null;
            }
        }.start();
    }

    protected void restoreState(final Object node, final List<Object> path) {
        new EDTHelper<Object>(){

            @Override
            public Object edtRun() {
                if (node == null) {
                    return null;
                }
                path.add(node);
                TreeModelStateSaver.this.treePath = new TreePath(path.toArray(new Object[0]));
                Boolean bo = (Boolean)TreeModelStateSaver.this.expandCache.get(node);
                try {
                    if (bo != null && bo.booleanValue()) {
                        TreeModelStateSaver.this.tree.expandPath(TreeModelStateSaver.this.treePath);
                    }
                }
                catch (Throwable e) {
                    LogV3.log(e);
                }
                for (int i = 0; i < TreeModelStateSaver.this.tree.getModel().getChildCount(node); ++i) {
                    try {
                        TreeModelStateSaver.this.restoreState(TreeModelStateSaver.this.tree.getModel().getChild(node, i), new ArrayList<Object>(path));
                        continue;
                    }
                    catch (Throwable e) {
                        LogV3.log(e);
                    }
                }
                return null;
            }
        }.start();
    }

    public void save() {
        if (this.tree.getModel() != null) {
            this.saveState(this.tree.getModel().getRoot(), new ArrayList<Object>());
        }
        this.selectedPaths = this.tree.getSelectionPaths();
    }

    private void saveState(Object node, List<Object> path) {
        path.add(node);
        try {
            this.treePath = new TreePath(path.toArray(new Object[0]));
            this.expandCache.put(node, this.tree.isExpanded(this.treePath));
        }
        catch (Exception e) {
            LogV3.log(e);
        }
        int max = this.tree.getModel().isLeaf(node) ? 0 : this.tree.getModel().getChildCount(node);
        for (int i = 0; i < max; ++i) {
            try {
                this.saveState(this.tree.getModel().getChild(node, i), new ArrayList<Object>(path));
            }
            catch (Exception e) {
                LogV3.log(e);
            }
            this.tree.getModel().getChildCount(node);
        }
    }

    public void setSelectedPaths(TreePath[] selectedPathes) {
        this.selectedPaths = selectedPathes;
    }
}

