/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.installer;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.net.httpconnection.HTTPProxyStorable;
import org.jdownloader.updatev2.InternetConnectionSettings;
import org.jdownloader.updatev2.ProxyData;

public class Installer {
    public static List<HTTPProxyStorable> getProxyList(File contentDir) {
        File dest = new File(contentDir, "cfg/org.jdownloader.settings.InternetConnectionSettings");
        String path = dest.getAbsoluteFile() + ".customproxylist.json";
        System.out.println("CustomProxyListPath: " + path);
        File customproxylist = new File(path);
        boolean existsBefore1 = customproxylist.exists();
        boolean existsBefore2 = customproxylist.getParentFile().exists();
        boolean existsBefore3 = customproxylist.getParentFile().getParentFile().exists();
        InternetConnectionSettings config = JsonConfig.create(dest, InternetConnectionSettings.class);
        ArrayList<ProxyData> lst = config.getCustomProxyList();
        Installer.cleanup(customproxylist, existsBefore1, existsBefore2, existsBefore3);
        ArrayList<HTTPProxyStorable> proxyList = new ArrayList<HTTPProxyStorable>();
        if (lst != null) {
            for (ProxyData pd : lst) {
                proxyList.add(pd.getProxy());
            }
        }
        return proxyList;
    }

    public static void cleanup(File customproxylist, boolean existsBefore1, boolean existsBefore2, boolean existsBefore3) {
        if (!existsBefore1) {
            customproxylist.delete();
        }
        if (!existsBefore2) {
            customproxylist.getParentFile().delete();
        }
        if (!existsBefore3) {
            customproxylist.getParentFile().getParentFile().delete();
        }
    }

    public static void addProxy(File contentDir, HTTPProxyStorable proxystorable) {
        if (proxystorable == null || proxystorable.getType() == HTTPProxyStorable.TYPE.NONE) {
            return;
        }
        File dest = new File(contentDir, "cfg/org.jdownloader.settings.InternetConnectionSettings");
        InternetConnectionSettings config = JsonConfig.create(dest, InternetConnectionSettings.class);
        ArrayList<ProxyData> lst = config.getCustomProxyList();
        if (lst == null) {
            lst = new ArrayList();
        }
        HTTPProxy proxy = HTTPProxy.getHTTPProxy(proxystorable);
        boolean found = false;
        for (ProxyData pd : lst) {
            if (!HTTPProxy.getHTTPProxy(pd.getProxy()).equals(proxy)) continue;
            found = true;
        }
        if (!found) {
            ProxyData newpd = new ProxyData();
            newpd.setEnabled(true);
            newpd.setProxy(proxystorable);
            lst.add(0, newpd);
        }
        config.setCustomProxyList(lst);
    }
}

