/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.update.awf;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.appwork.updatesys.client.ModuleProgress;
import org.appwork.updatesys.transport.exchange.PackageResponse;
import org.appwork.utils.awfc.AWFCEntry;
import org.appwork.utils.awfc.AWFCInputStream;
import org.jdownloader.update.AWFUpdatePackage;
import org.jdownloader.update.JDUpdateClient;

public class AWFArchive {
    private final AWFUpdatePackage updatePackage;
    private ModuleProgress progress;
    private final JDUpdateClient client;

    public AWFArchive(JDUpdateClient client, AWFUpdatePackage updatePackage) {
        this.updatePackage = updatePackage;
        this.client = client;
        this.progress = new ModuleProgress();
    }

    public ModuleProgress getProgress() {
        return this.progress;
    }

    public void setProgress(ModuleProgress progress) {
        this.progress = progress;
    }

    private void checkInterruption() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException("Has been interruped");
        }
    }

    public List<String> list() throws IOException, InterruptedException {
        File file = this.updatePackage.getFile();
        AWFCInputStream input = null;
        try {
            this.progress.setIndeterminated(true);
            PackageResponse dummyResponse = new PackageResponse(this.updatePackage.getdRev(), null, this.updatePackage.getFile().length(), this.updatePackage.getFile().length(), this.updatePackage.isEncrypted(), null);
            input = this.client.openAWFCInputStream(file, dummyResponse, this.updatePackage.isExtracted());
            ArrayList<String> list = new ArrayList<String>();
            AWFCEntry entry = null;
            while ((entry = input.getNextEntry()) != null) {
                this.checkInterruption();
                String relPath = entry.getPath().replace("\\", "/");
                while (relPath.endsWith("/")) {
                    relPath = relPath.substring(0, relPath.length() - 1);
                }
                list.add(relPath);
            }
            ArrayList<String> arrayList = list;
            return arrayList;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.client.getFileSystem().deleteFileIfExists(file);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (Throwable throwable) {}
            this.progress.setIndeterminated(false);
            this.progress.fillStep();
        }
    }
}

