/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.update.gui.bubble;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.appwork.resources.AWUTheme;
import org.appwork.swing.MigPanel;
import org.appwork.utils.swing.SwingUtils;
import org.jdownloader.update.gui.bubble.AbstractNotifyWindow;
import org.jdownloader.update.gui.bubble.IconedProcessIndicator;

public abstract class AbstractBubbleContentPanel
extends MigPanel {
    protected IconedProcessIndicator progressCircle;
    protected long startTime;
    private AbstractNotifyWindow<?> window;

    private String clean(String label) {
        label = label.trim();
        while (label.endsWith(":")) {
            label = label.substring(0, label.length() - 1);
        }
        return label + ":";
    }

    public void setWindow(AbstractNotifyWindow<?> window) {
        this.window = window;
    }

    public AbstractNotifyWindow<?> getWindow() {
        return this.window;
    }

    public abstract void updateLayout();

    protected Pair addPair(Pair existingPair, String lbl, Icon iconWait) {
        if (existingPair == null) {
            existingPair = new Pair();
            existingPair.lbl = this.createHeaderLabel(lbl, iconWait);
            existingPair.value = new JLabel("");
        }
        this.add((Component)existingPair.lbl, "hidemode 3");
        this.add((Component)existingPair.value, "hidemode 3");
        return existingPair;
    }

    protected Pair addPair(Pair existingPair, String lbl, String icon) {
        return this.addPair(existingPair, lbl, AWUTheme.I().getIcon(icon, 18));
    }

    protected Pair addPair(String lbl, String iconWait) {
        return this.addPair(null, lbl, iconWait);
    }

    public void stop() {
        this.progressCircle.setIndeterminate(false);
        this.progressCircle.setMaximum(100);
        this.progressCircle.setValue(100);
    }

    protected JLabel createHeaderLabel(String lbl, Icon icon) {
        JLabel ret = this.createHeaderLabel(lbl);
        if (icon != null) {
            ret.setDisabledIcon(icon);
            ret.setHorizontalTextPosition(2);
        }
        return ret;
    }

    protected JLabel createHeaderLabel(String lbl, String icon) {
        return this.createHeaderLabel(lbl, AWUTheme.I().getIcon(icon, 18));
    }

    protected JLabel createHeaderLabel(String label) {
        JLabel lbl = new JLabel(this.clean(label));
        SwingUtils.toBold(lbl);
        lbl.setEnabled(false);
        lbl.setHorizontalAlignment(4);
        return lbl;
    }

    public AbstractBubbleContentPanel(String iconKey) {
        this(AWUTheme.I().getIcon(iconKey, 20));
    }

    public AbstractBubbleContentPanel(Icon icon) {
        super("ins 3 3 0 3,wrap 3", "[][fill][grow,fill]", "[]");
        this.progressCircle = new IconedProcessIndicator(icon);
        this.progressCircle.setIndeterminate(false);
        this.progressCircle.setEnabled(false);
        this.progressCircle.setValue(100);
        this.addProgress();
        this.startTime = System.currentTimeMillis();
        SwingUtils.setOpaque(this, false);
    }

    protected void addProgress() {
        this.add((Component)this.progressCircle, "width 32!,height 32!,pushx,growx,pushy,growy,spany,aligny top");
    }

    public AbstractBubbleContentPanel() {
        super("ins 3 3 0 3,wrap 2", "[fill][grow,fill]", "[]");
        this.startTime = System.currentTimeMillis();
        SwingUtils.setOpaque(this, false);
    }

    public class Pair {
        public JLabel lbl;
        public JLabel value;

        public void setText(Object v) {
            this.value.setText(v + "");
        }

        public void setVisible(boolean b) {
            this.lbl.setVisible(b);
            this.value.setVisible(b);
        }

        public void setTooltip(String filePath) {
            this.lbl.setToolTipText(filePath);
            this.value.setToolTipText(filePath);
        }
    }
}

