/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.updatev2.restart;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import org.appwork.utils.Application;
import org.appwork.utils.Hash;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.updatev2.RestartController;
import org.jdownloader.updatev2.restart.Restarter;

public class WindowsRestarter
extends Restarter {
    @Override
    protected List<String> getApplicationStartCommands(File root) {
        if (!Application.isHeadless()) {
            String[] binaryPaths;
            for (String binaryPath : binaryPaths = new String[]{"JDownloader2.exe", "JDownloader 2.exe", "JDownloader.exe"}) {
                File restartBinary = new File(root, binaryPath);
                if (!restartBinary.exists() || !restartBinary.isFile()) continue;
                try {
                    String binaryHash = Hash.getMD5(restartBinary);
                    if ("a08b3424355c839138f326c06a964b9e".equals(binaryHash)) {
                        this.getLogger().info("Workaround: found locking binary: " + binaryHash);
                        continue;
                    }
                }
                catch (Throwable e) {
                    this.getLogger().log(e);
                }
                this.getLogger().info("Found binary: " + restartBinary + " for restart");
                ArrayList<String> ret = new ArrayList<String>();
                ret.add(restartBinary.getAbsolutePath());
                return ret;
            }
        }
        this.getLogger().info("No binary found! Will use JavaBinary!");
        ArrayList<String> ret = new ArrayList<String>();
        ret.addAll(this.getJVMApplicationStartCommands(root));
        return ret;
    }

    @Override
    protected List<String> getJVMApplicationStartCommands(File root) {
        ArrayList<String> jvmParameter = new ArrayList<String>();
        jvmParameter.add(CrossSystem.getJavaBinary());
        List<String> lst = ManagementFactory.getRuntimeMXBean().getInputArguments();
        for (String h : lst) {
            if (h.equals("exit")) {
                this.getLogger().info("Workaround: removing buggy exit parameter");
                continue;
            }
            if (h.startsWith("-agentlib:")) continue;
            jvmParameter.add(h);
        }
        jvmParameter.add("-jar");
        try {
            jvmParameter.add(Application.getJarName(RestartController.class));
        }
        catch (IllegalStateException e) {
            jvmParameter.add("JDownloader.jar");
        }
        return jvmParameter;
    }
}

