/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.builddecision;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.appwork.builddecision.BuildDecisionData;
import org.appwork.builddecision.BuildDecisionRequired;
import org.appwork.exceptions.WTFException;
import org.appwork.loggingv3.LogV3;
import org.appwork.testframework.AWTestValidateClassReference;
import org.appwork.utils.Application;
import org.appwork.utils.ClassPathScanner;
import org.appwork.utils.DebugMode;
import org.appwork.utils.Joiner;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.StringUtils;
import org.appwork.utils.Time;
import org.appwork.utils.logging2.LogInterface;

public class BuildDecisions {
    private static final Map<String, BuildDecisionInfo> INSTANCE = new HashMap<String, BuildDecisionInfo>();
    @AWTestValidateClassReference
    public static final String IDETestRunnerClass = "org.appwork.testframework.IDETestRunner";
    private static boolean ENABLED = true;

    private BuildDecisions() {
    }

    public static boolean add(String tag, Class<?> ... loadedImports) {
        return INSTANCE.put(tag, new BuildDecisionInfo(loadedImports)) == null;
    }

    public static boolean contains(String tag) {
        return INSTANCE.containsKey(tag);
    }

    public static boolean remove(String tag) {
        return INSTANCE.remove(tag) != null;
    }

    public static File getProjectFolder(Class<?> cls) {
        URL url = Application.class.getResource("/" + cls.getName().replace(".", "/") + ".class");
        try {
            File file = new File(url.toURI()).getParentFile();
            for (int i = 0; i < cls.getName().split("\\.").length; ++i) {
                file = file.getParentFile();
            }
            if ("production".equals(file.getName()) && "bin".equals(file.getParentFile().getName())) {
                return file.getParentFile().getParentFile();
            }
            return file;
        }
        catch (Throwable e) {
            throw new WTFException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validate() {
        block15: {
            if (!ENABLED) {
                return;
            }
            if (System.getProperty("AWTEST") != null) {
                return;
            }
            final Class<?> mainClass = Application.getMainClass();
            if (mainClass != null && ReflectionUtils.isInstanceOf(IDETestRunnerClass, mainClass)) {
                return;
            }
            final ArrayList<Exception> exceptions = new ArrayList<Exception>();
            try {
                RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
                String cp = runtimeMXBean.getClassPath();
                String command = runtimeMXBean.getSystemProperties().get("sun.java.command");
                LogV3.info("Classpath: " + cp);
                LogV3.info("Command: " + command);
                if (command == null || command.isEmpty()) break block15;
                long started = Time.systemIndependentCurrentJVMTimeMillis();
                File projectFolder = BuildDecisions.getProjectFolder(mainClass);
                try {
                    new ClassPathScanner<Throwable>(){

                        @Override
                        public void handle(Class<?> type) throws Throwable {
                            block8: {
                                try {
                                    BuildDecisionRequired anno = type.getAnnotation(BuildDecisionRequired.class);
                                    if (anno == null) break block8;
                                    BuildDecisionData s = new BuildDecisionData(anno, type);
                                    List<BuildDecisionData.Option> options = s.getOptions();
                                    BuildDecisionData.Option usedTag = null;
                                    for (BuildDecisionData.Option o : options) {
                                        BuildDecisionInfo d = BuildDecisions.get(o.getTag());
                                        if (d == null) continue;
                                        usedTag = o;
                                        for (String imp : o.getImports()) {
                                            if (StringUtils.isEmpty(imp)) continue;
                                            Class<?> cls = null;
                                            try {
                                                cls = Class.forName(imp, false, BuildDecisions.class.getClassLoader());
                                            }
                                            catch (Exception e) {
                                                throw new Exception("Cannot load required class. Launcher: " + mainClass + "!\r\nEnsure that  " + imp + " is imported!\r\nRequired by BuildTag " + usedTag + "\r\nIn " + s.getClass() + "", e);
                                            }
                                            if (Arrays.asList(d.loadedImports).contains(cls)) continue;
                                            throw new Exception("The class-reference fails in BuildDecisions.add(...) " + mainClass + "!\r\nEnsure that  " + imp + " is added as parameter \r\nRequired by BuildTag " + usedTag + "\r\nIn " + s.getClass() + "");
                                        }
                                        String[] deps = o.getDependsOn();
                                        if (deps == null) continue;
                                        for (String dep : deps) {
                                            if (StringUtils.isEmpty(dep) || BuildDecisions.contains(dep)) continue;
                                            throw new Exception("The  BuildDecision Tag requires a dependency: Launcher:" + mainClass + " (" + mainClass.getSimpleName() + ".java:1):\r\nMissing Tag: " + dep);
                                        }
                                    }
                                    if (usedTag == null) {
                                        throw new Exception("Could not find any BuildDecision Tag in " + mainClass + " (" + mainClass.getSimpleName() + ".java:1):\r\nChoose one:" + new Joiner("\r\n").prefix(true).join((Collection<?>)options));
                                    }
                                }
                                catch (Exception e) {
                                    exceptions.add(e);
                                }
                            }
                        }
                    }.run();
                }
                catch (Throwable e) {
                    throw new Exception(e);
                }
                finally {
                    System.out.println("BuildDecision Scan took: " + (Time.systemIndependentCurrentJVMTimeMillis() - started));
                }
            }
            catch (Exception e) {
                exceptions.add(e);
            }
            finally {
                for (Exception e : exceptions) {
                    System.err.println(e.getMessage());
                }
                if (exceptions.size() > 0) {
                    DebugMode.debugger();
                }
            }
        }
    }

    protected static BuildDecisionInfo get(String tag) {
        return INSTANCE.get(tag);
    }

    public static void setEnabled(boolean enabled) {
        ENABLED = enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void status(LogInterface logger) {
        block16: {
            try {
                String cp;
                if (logger == null) {
                    return;
                }
                RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
                if (bean != null && (cp = bean.getClassPath()) != null) {
                    for (String s : cp.split(File.pathSeparator)) {
                        logger.info("ClassPath: " + s.replaceAll("^.*?[/\\\\]libs[/\\\\]", "libs/"));
                        if (!s.endsWith(".jar")) continue;
                        JarFile jf = null;
                        try {
                            jf = new JarFile(s);
                            Manifest manifest = jf.getManifest();
                            if (manifest != null) {
                                Attributes attributes = manifest.getMainAttributes();
                                for (Object key : attributes.keySet()) {
                                    logger.info(StringUtils.fillPost("", " ", "ClassPath: ".length()) + key + ": " + attributes.getValue(String.valueOf(key)));
                                }
                                continue;
                            }
                            logger.info(StringUtils.fillPost("", " ", s.length()) + "- no Manifest");
                        }
                        finally {
                            if (jf != null) {
                                jf.close();
                            }
                        }
                    }
                }
                for (Map.Entry<String, BuildDecisionInfo> es : INSTANCE.entrySet()) {
                    String str = "Build Decision: " + es.getKey();
                    Class<?>[] imports = es.getValue().getLoadedImports();
                    if (imports == null || imports.length == 0) {
                        str = str + "\r\n-no-classes-";
                    } else {
                        for (Class<?> cls : imports) {
                            String version = cls.getPackage().getImplementationVersion();
                            URL url = cls.getClassLoader().getResource(cls.getName().replace(".", "/") + ".class");
                            str = str + "\r\nLoaded library: " + cls.getPackage().getImplementationTitle() + "/" + cls.getPackage().getImplementationVendor() + "\r\nClass: " + cls + "\r\nVersion: " + version + "\r\nLoaded from: " + url;
                        }
                    }
                    logger.info(str);
                }
            }
            catch (Throwable e) {
                if (e instanceof InterruptedException) {
                    DebugMode.debugger();
                    Thread.currentThread().interrupt();
                }
                if (logger == null) break block16;
                logger.log(e);
            }
        }
    }

    public static boolean isEnabled() {
        return ENABLED;
    }

    public static boolean isEmpty() {
        return INSTANCE.isEmpty();
    }

    private static class BuildDecisionInfo {
        private Class<?>[] loadedImports;

        public Class<?>[] getLoadedImports() {
            return this.loadedImports;
        }

        public void setLoadedImports(Class<?>[] loadedImports) {
            this.loadedImports = loadedImports;
        }

        public BuildDecisionInfo(Class<?>[] loadedImports) {
            this.loadedImports = loadedImports;
        }
    }
}

