/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.controlling;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.appwork.controlling.State;
import org.appwork.controlling.StateConflictException;
import org.appwork.controlling.StateEvent;
import org.appwork.controlling.StateEventListener;
import org.appwork.controlling.StateEventsender;
import org.appwork.controlling.StateListener;
import org.appwork.controlling.StateMachineInterface;
import org.appwork.controlling.StatePathEntry;
import org.appwork.controlling.StateViolationException;
import org.appwork.loggingv3.LogV3;

public class StateMachine {
    private final State initState;
    private volatile State currentState;
    private final StateEventsender eventSender;
    private final State finalState;
    private final List<StatePathEntry> path;
    private final StateMachineInterface owner;
    private final Object lock = new Object();
    private final Object lock2 = new Object();
    private final HashMap<State, Throwable> exceptionMap;

    private static State checkState(State state) {
        State finalState = null;
        for (State s : state.getChildren()) {
            State ret = StateMachine.checkState(s);
            if (finalState == null) {
                finalState = ret;
            }
            if (finalState == ret) continue;
            throw new StateConflictException("States do not all result in one common final state");
        }
        if (finalState == null) {
            throw new StateConflictException(state + " is a blind state (has no children)");
        }
        return finalState;
    }

    public static void validateStateChain(State initState) {
        if (initState.getParents().size() > 0) {
            throw new StateConflictException("initState must not have a parent");
        }
        StateMachine.checkState(initState);
    }

    public StateMachine(StateMachineInterface interfac, State startState, State endState) {
        this.owner = interfac;
        this.initState = startState;
        this.currentState = startState;
        this.finalState = endState;
        this.exceptionMap = new HashMap();
        this.eventSender = new StateEventsender();
        this.path = new ArrayList<StatePathEntry>();
        this.path.add(new StatePathEntry(this.initState));
    }

    public void addListener(StateEventListener listener) {
        this.eventSender.addListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeIfOnState(Runnable run, State state) {
        if (run == null || state == null) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.isState(state)) {
                run.run();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeOnceOnState(final Runnable run, State state) {
        if (run == null || state == null) {
            return;
        }
        boolean reached = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.hasPassed(state)) {
                reached = true;
            } else {
                this.addListener(new StateListener(state){

                    @Override
                    public void onStateReached(StateEvent event) {
                        StateMachine.this.removeListener(this);
                        run.run();
                    }
                });
            }
            if (reached) {
                new Thread(run, "AsyncOnStateWorker").start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireUpdate(State currentState) {
        if (currentState != null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.currentState != currentState) {
                    throw new StateConflictException("Cannot update state " + currentState + " because current state is " + this.currentState);
                }
            }
        }
        StateEvent event = new StateEvent(this, StateEvent.Types.UPDATED, currentState, currentState);
        this.eventSender.fireEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceState(State newState) {
        StateEvent event;
        Object object = this.lock;
        synchronized (object) {
            if (this.currentState == newState) {
                return;
            }
            event = new StateEvent(this, StateEvent.Types.CHANGED, this.currentState, newState);
            Object object2 = this.lock2;
            synchronized (object2) {
                this.path.add(new StatePathEntry(newState));
            }
            LogV3.finest(this.owner + " State changed " + this.currentState + " -> " + newState);
            this.currentState = newState;
        }
        this.eventSender.fireEvent(event);
    }

    public Throwable getCause(State newState) {
        return this.exceptionMap.get(newState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatePathEntry getLatestStateEntry(State failedState) {
        try {
            StatePathEntry entry = null;
            Object object = this.lock2;
            synchronized (object) {
                for (int i = this.path.size() - 1; i >= 0; --i) {
                    entry = this.path.get(i);
                    if (entry.getState() != failedState) continue;
                    return entry;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public StateMachineInterface getOwner() {
        return this.owner;
    }

    public List<StatePathEntry> getPath() {
        return this.path;
    }

    public State getState() {
        return this.currentState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPassed(State ... states) {
        Object object = this.lock2;
        synchronized (object) {
            for (State s : states) {
                for (StatePathEntry e : this.path) {
                    if (e.getState() != s) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFinal() {
        Object object = this.lock;
        synchronized (object) {
            return this.finalState == this.currentState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStartState() {
        Object object = this.lock;
        synchronized (object) {
            return this.currentState == this.initState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isState(State ... states) {
        Object object = this.lock;
        synchronized (object) {
            for (State s : states) {
                if (s != this.currentState) continue;
                return true;
            }
        }
        return false;
    }

    public void removeListener(StateEventListener listener) {
        this.eventSender.removeListener(listener);
    }

    public void reset() {
        this.reset(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(boolean force) {
        StateEvent event;
        Object object = this.lock;
        synchronized (object) {
            if (this.currentState == this.initState) {
                return;
            }
            if (!force && this.finalState != this.currentState) {
                throw new StateConflictException("Cannot reset from state " + this.currentState);
            }
            event = new StateEvent(this, StateEvent.Types.CHANGED, this.currentState, this.initState);
            LogV3.finest(this.owner + " State changed (reset) " + this.currentState + " -> " + this.initState);
            this.currentState = this.initState;
            Object object2 = this.lock2;
            synchronized (object2) {
                this.path.clear();
                this.path.add(new StatePathEntry(this.initState));
            }
        }
        this.eventSender.fireEvent(event);
    }

    public void setCause(State failedState, Throwable e) {
        this.exceptionMap.put(failedState, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(State newState) {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentState == newState) {
                return;
            }
            if (!this.currentState.getChildren().contains(newState)) {
                throw new StateConflictException("Cannot change state from " + this.currentState + " to " + newState);
            }
        }
        this.forceState(newState);
    }

    public void validateState(State state) {
        if (!this.isState(state)) {
            throw new StateViolationException(state);
        }
    }
}

