/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.io.streams.signature;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import javax.crypto.Mac;
import org.appwork.io.streams.signature.DigestInterface;
import org.appwork.io.streams.signature.DigesterOutputStream;
import org.appwork.io.streams.signature.MacDigester;
import org.appwork.io.streams.signature.MessageDigester;
import org.appwork.utils.IO;

public class StreamSignatureCreatingOutputStream
extends OutputStream {
    public static final long STREAM_VERSION_08_10_2021 = 1L;
    public static final byte[] END_SIGNATURE_SALT = new byte[]{84, 104, 101, 69, 110, 100};
    private final DigestInterface digester;
    private long chunkLength;
    private long remainingFrameSize;
    private boolean signatureRequest;
    private final byte[] nonceBytes;
    private byte[] lastFrameSignature;
    private long payloadBytesWritten = 0L;
    private long rawBytesWritten = 0L;
    private OutputStream out;
    private final long streamVersion;
    private DataOutputStream digesterStream;
    private boolean closed;

    public long getChunkLength() {
        return this.chunkLength;
    }

    public void setChunkLength(long chunkLength) {
        this.chunkLength = chunkLength;
    }

    public long getPayloadBytesWritten() {
        return this.payloadBytesWritten;
    }

    public long getRawBytesWritten() {
        return this.rawBytesWritten;
    }

    public StreamSignatureCreatingOutputStream(OutputStream out, Mac mac, byte[] nonceBytes, int interval) {
        this(out, new MacDigester(mac), nonceBytes, interval);
    }

    public StreamSignatureCreatingOutputStream(OutputStream out, MessageDigest digest, byte[] nonceBytes, int interval) {
        this(out, new MessageDigester(digest), nonceBytes, interval);
    }

    public StreamSignatureCreatingOutputStream(OutputStream out, DigestInterface digester, byte[] nonceBytes, int interval) {
        this(out, digester, nonceBytes, interval, 1L);
    }

    public StreamSignatureCreatingOutputStream(OutputStream out, DigestInterface digester, byte[] nonceBytes, int interval, long streamVersion) {
        this.streamVersion = streamVersion;
        this.out = out;
        this.signatureRequest = false;
        this.nonceBytes = nonceBytes;
        this.chunkLength = interval;
        this.digester = digester;
        this.digesterStream = new DataOutputStream(new DigesterOutputStream(digester));
    }

    public long getStreamVersion() {
        return this.streamVersion;
    }

    protected void initChunkDigester(long chunkSize) throws IOException {
        this.digester.doFinal();
        StreamSignatureCreatingOutputStream.initChunkDigesterStatic(this.digesterStream, this.streamVersion, chunkSize, this.nonceBytes, this.lastFrameSignature);
    }

    public static void initChunkDigesterStatic(DataOutputStream digesterStream, long streamVersion, long chunkSize, byte[] nonceBytes, byte[] lastFrameSignature) throws IOException {
        digesterStream.writeLong(streamVersion);
        digesterStream.writeLong(chunkSize);
        if (nonceBytes != null) {
            digesterStream.write(nonceBytes);
        }
        if (lastFrameSignature != null) {
            digesterStream.write(lastFrameSignature);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.internalWrite(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.internalWrite(b, off, len);
    }

    protected void internalWrite(byte[] b, int off, int len) throws IOException, UnsupportedEncodingException {
        int toWrite;
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        do {
            if (this.payloadBytesWritten == 0L) {
                this.rawBytesWritten += (long)IO.writeLongOptimized(this.getStreamVersion(), this.out);
            }
            if (this.signatureRequest) {
                this.writeSignature();
            }
            if (this.remainingFrameSize == 0L) {
                this.remainingFrameSize = this.nextChunk();
                this.writeNextChunkSize(this.remainingFrameSize);
                this.initChunkDigester(this.remainingFrameSize);
            }
            toWrite = (int)Math.min(this.remainingFrameSize, (long)len);
            this.writeToOut(b, off, toWrite);
            this.payloadBytesWritten += (long)toWrite;
            this.digesterStream.write(b, off, toWrite);
            this.remainingFrameSize -= (long)toWrite;
            if (this.remainingFrameSize == 0L) {
                this.signatureRequest = true;
            }
            off += toWrite;
        } while ((len -= toWrite) != 0);
    }

    protected void writeToOut(byte[] b, int off, int toWrite) throws IOException {
        this.out.write(b, off, toWrite);
        this.rawBytesWritten += (long)toWrite;
    }

    protected void writeSignature() throws IOException {
        this.lastFrameSignature = this.digester.doFinal();
        this.writeToOut(this.lastFrameSignature, 0, this.lastFrameSignature.length);
        this.signatureRequest = false;
    }

    protected long nextChunk() {
        return this.chunkLength;
    }

    private void writeNextChunkSize(long v) throws IOException {
        this.rawBytesWritten += (long)IO.writeLongOptimized(v, this.out);
    }

    public long getInterval() {
        return this.chunkLength;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.writeEndSignature();
        this.out.close();
        this.closed = true;
    }

    protected void writeEndSignature() throws IOException {
        if (this.rawBytesWritten == 0L) {
            this.write(new byte[0]);
        }
        this.digesterStream.write(END_SIGNATURE_SALT);
        this.writeSignature();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void write(int b) throws IOException {
        this.internalWrite(new byte[]{(byte)b}, 0, 1);
    }
}

