/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.jna.processes;

import com.sun.jna.LastErrorException;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import org.appwork.jna.windows.Kernel32Ext;
import org.appwork.loggingv3.LogV3;
import org.appwork.loggingv3.simple.SimpleLoggerFactory;
import org.appwork.loggingv3.simple.sink.LogToStdOutSink;
import org.appwork.utils.Application;

public class CTRLSender {
    private static final int EXCEPTIOn = 2;
    private static final int PROCESS_NOT_FOUND = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block21: {
            try {
                Application.setApplication(".AppWorkUtils");
                System.out.println("I'm a helper process");
                SimpleLoggerFactory fac = new SimpleLoggerFactory();
                fac.addSink(new LogToStdOutSink());
                LogV3.setFactory(fac);
                int pid = Integer.parseInt(args[0]);
                LogV3.info("Send CTRL " + pid + "(" + pid + ")");
                WinNT.HANDLE processHandle = Kernel32.INSTANCE.OpenProcess(1024, false, pid);
                try {
                    if (processHandle == null) {
                        LogV3.info("Process handle gone. Fine");
                        System.exit(1);
                        return;
                    }
                    IntByReference exitCode = new IntByReference();
                    if (Kernel32.INSTANCE.GetExitCodeProcess(processHandle, exitCode) && exitCode.getValue() != 259) {
                        LogV3.info("Process gone. Fine");
                        System.exit(1);
                        return;
                    }
                }
                finally {
                    if (processHandle != null) {
                        Kernel32Ext.INSTANCE.CloseHandle(processHandle);
                    }
                }
                Kernel32Ext.INSTANCE.FreeConsole();
                Kernel32.INSTANCE.SetLastError(0);
                if (Kernel32Ext.INSTANCE.AttachConsole(pid)) {
                    Kernel32Ext.INSTANCE.SetConsoleCtrlHandler(null, true);
                    try {
                        Kernel32.INSTANCE.SetLastError(0);
                        boolean success = Kernel32.INSTANCE.GenerateConsoleCtrlEvent(0, pid);
                        LogV3.info("CTRL Success Result: " + success);
                        if (!success) {
                            throw new Exception("Could not send CTRL");
                        }
                        break block21;
                    }
                    finally {
                        try {
                            Kernel32Ext.INSTANCE.SetConsoleCtrlHandler(null, false);
                        }
                        finally {
                            Kernel32.INSTANCE.FreeConsole();
                        }
                    }
                }
                int error = Kernel32.INSTANCE.GetLastError();
                if (error != 0) {
                    throw new LastErrorException(error);
                }
            }
            catch (Throwable e) {
                LogV3.log(e);
                System.exit(2);
            }
        }
    }
}

