/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.loggingv3.simple;

import org.appwork.loggingv3.AbstractLogger;
import org.appwork.loggingv3.simple.LogRecord2;
import org.appwork.loggingv3.simple.LogV3Level;
import org.appwork.loggingv3.simple.SinkProvider;
import org.appwork.utils.logging2.LogInterface;

public class LoggerToSink
extends AbstractLogger {
    protected final SinkProvider sinkProvider;

    public LoggerToSink(SinkProvider sinkprovider) {
        this.sinkProvider = sinkprovider;
    }

    @Override
    public void info(String msg) {
        if (msg == null || msg.trim().length() == 0) {
            return;
        }
        this.sinkProvider.publish(new LogRecord2((LogInterface)this, msg, this.getThrownAt()));
    }

    @Override
    public void log(Throwable e) {
        this.sinkProvider.publish(new LogRecord2((LogInterface)this, LoggerToSink.getStackTrace(e), this.getThrownAt()).level(LogV3Level.EXCEPTION));
    }

    @Override
    public void exception(String msg, Throwable e) {
        this.sinkProvider.publish(new LogRecord2((LogInterface)this, msg + "\r\n" + LoggerToSink.getStackTrace(e), this.getThrownAt()).level(LogV3Level.EXCEPTION));
    }
}

