/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.propertystate;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.appwork.loggingv3.LogV3;
import org.appwork.propertystate.EmptyStateImpl;
import org.appwork.propertystate.PropertyAccess;
import org.appwork.propertystate.PropertyState;
import org.appwork.propertystate.PropertyStateImpl;
import org.appwork.propertystate.PropertyStateIndexCache;
import org.appwork.propertystate.SinglePropertyStateImpl;
import org.appwork.storage.flexijson.FlexiJSonNode;
import org.appwork.storage.flexijson.mapper.FlexiJSonMapper;
import org.appwork.storage.flexijson.mapper.FlexiMapperException;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.reflection.Clazz;
import org.appwork.utils.reflection.CompiledType;

public class Manager {
    static final String INDEX_PROPERTY = "_";
    private static final Map<String, Object> EMPTY_MAP = Collections.unmodifiableMap(new HashMap());
    private LinkedList<WeakReference<PropertyState>> states = new LinkedList();
    private EmptyStateImpl empty;
    private Class<?> propertyAccessClassContainer;
    protected final ThreadLocal<PropertyStateIndexCache> threadIndexCache = new ThreadLocal();

    public Manager(Class<?> propertyAccessClassContainer) {
        this.empty = new EmptyStateImpl(this);
        this.propertyAccessClassContainer = propertyAccessClassContainer;
        this.states.add(new WeakReference<EmptyStateImpl>(this.empty));
    }

    public PropertyState deriveNewInstance(PropertyState currentState, String key, Object arg) {
        if (currentState == null || currentState == this.getEmptyState()) {
            return new SinglePropertyStateImpl(this, key, arg);
        }
        return new PropertyStateImpl(this, currentState, key, arg);
    }

    protected Map<String, Object> fixImportMap(Class<?> class1, Map<String, Object> map) {
        FlexiJSonMapper mapper = null;
        HashMap<String, Object> ret = null;
        for (Field f : class1.getDeclaredFields()) {
            if (!PropertyAccess.class.isAssignableFrom(f.getType()) || !Modifier.isStatic(f.getModifiers())) continue;
            try {
                f.setAccessible(true);
                PropertyAccess access = (PropertyAccess)f.get(null);
                if (!map.containsKey(access.getKey())) continue;
                Object value = map.get(access.getKey());
                if (value == null) {
                    Object newValue = ReflectionUtils.cast(value, access.getRawClass());
                    if (newValue == null || newValue == value) continue;
                    if (ret == null) {
                        ret = new HashMap<String, Object>(map);
                    }
                    ret.put(access.getKey(), newValue);
                    continue;
                }
                if (access.getRawClass().isEnum()) {
                    if (!(value instanceof String)) continue;
                    Object enumValue = Enum.valueOf(access.getRawClass(), (String)value);
                    if (ret == null) {
                        ret = new HashMap<String, Object>(map);
                    }
                    ret.put(access.getKey(), enumValue);
                    continue;
                }
                if (Clazz.isPrimitive(access.getRawClass()) || access.getRawClass() == String.class) continue;
                if (mapper == null) {
                    mapper = new FlexiJSonMapper();
                }
                if (value == null || access.getRawClass().isAssignableFrom(value.getClass())) continue;
                FlexiJSonNode node = mapper.objectToJsonNode(value);
                Object fixedValue = mapper.jsonToObject(node, CompiledType.create(access.getType()));
                if (ret == null) {
                    ret = new HashMap<String, Object>(map);
                }
                ret.put(access.getKey(), fixedValue);
            }
            catch (IllegalArgumentException e) {
                LogV3.log(e);
            }
            catch (IllegalAccessException e) {
                LogV3.log(e);
            }
            catch (FlexiMapperException e) {
                LogV3.log(e);
            }
        }
        return ret == null ? map : ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyState createState(Map<String, Object> input) {
        if (input == null) {
            return this.empty;
        }
        if (input.size() == 0) {
            return this.empty;
        }
        Map<String, Object> map = input;
        Manager manager = this;
        synchronized (manager) {
            Number index = (Number)map.get(INDEX_PROPERTY);
            PropertyState found = this.getCached(map, index);
            if (found != null) {
                return found;
            }
            if (this.propertyAccessClassContainer != null) {
                map = this.fixImportMap(this.propertyAccessClassContainer, map);
            }
            Iterator it = this.states.iterator();
            while (it.hasNext()) {
                WeakReference ref = (WeakReference)it.next();
                PropertyState existing = (PropertyState)ref.get();
                if (existing == null) {
                    System.out.println("Cleanup unused state");
                    it.remove();
                    continue;
                }
                if (!existing.equalsMap(map)) continue;
                found = existing;
                break;
            }
            if (found == null) {
                found = this.deriveNewInstance(map);
                this.states.add(new WeakReference<PropertyState>(found));
            }
            this.putCached(index, found);
            return found;
        }
    }

    protected void putCached(Number index, PropertyState found) {
        if (index == null) {
            return;
        }
        PropertyStateIndexCache cache = this.threadIndexCache.get();
        if (cache != null) {
            cache.put(index.intValue(), found);
        }
    }

    protected PropertyState getCached(Map<String, Object> map, Number index) {
        if (index != null) {
            PropertyStateIndexCache cache = this.threadIndexCache.get();
            if (map.size() == 1) {
                if (cache == null) {
                    throw new IllegalStateException("Cannot resolve index reference - no Cache Controller is set for this thread/manager");
                }
                PropertyState hit = cache.getState(index.intValue());
                if (hit != null) {
                    return hit;
                }
                throw new IllegalStateException("Cannot find index in Cache Controller");
            }
        }
        return null;
    }

    public PropertyState deriveNewInstance(Map<String, Object> map) {
        if (map == null) {
            return this.empty;
        }
        if (map.size() == 0) {
            return this.empty;
        }
        boolean hasIndex = map.containsKey(INDEX_PROPERTY);
        PropertyState currentState = null;
        if (map.size() == 1 || map.size() == 2 && hasIndex) {
            for (Map.Entry<String, Object> e : map.entrySet()) {
                if (hasIndex && INDEX_PROPERTY.equals(e.getKey())) continue;
                currentState = new SinglePropertyStateImpl(this, e.getKey(), e.getValue());
            }
        } else {
            currentState = new PropertyStateImpl(this, map);
        }
        return currentState;
    }

    public PropertyState deriveNewInstanceWithoutKey(PropertyState currentState, String removeKey) {
        if (currentState == null || currentState == this.getEmptyState()) {
            return this.empty;
        }
        if (currentState.size() == 1 && currentState.containsKey(removeKey)) {
            return this.empty;
        }
        if (currentState.size() == 2 && currentState.containsKey(removeKey)) {
            for (String key : currentState.keySet()) {
                if (key.equals(removeKey)) continue;
                return new SinglePropertyStateImpl(this, key, currentState.get(key));
            }
            throw new IllegalStateException();
        }
        return new PropertyStateImpl(this, currentState, removeKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyState remove(PropertyState currentState, String key) {
        Manager manager = this;
        synchronized (manager) {
            Iterator it = this.states.iterator();
            while (it.hasNext()) {
                PropertyState existing = (PropertyState)((WeakReference)it.next()).get();
                if (existing == null) {
                    it.remove();
                    continue;
                }
                if (!existing.wouldEqualAfterRemoval(currentState == null ? this.empty : currentState, key)) continue;
                return existing;
            }
            currentState = this.deriveNewInstanceWithoutKey(currentState, key);
            this.states.add(new WeakReference<PropertyState>(currentState));
            return currentState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyState put(PropertyState currentState, String key, Object arg) {
        Manager manager = this;
        synchronized (manager) {
            Iterator it = this.states.iterator();
            while (it.hasNext()) {
                PropertyState existing = (PropertyState)((WeakReference)it.next()).get();
                if (existing == null) {
                    it.remove();
                    continue;
                }
                if (!existing.wouldEqualAfterModification(currentState == null ? this.empty : currentState, key, arg)) continue;
                return existing;
            }
            currentState = this.deriveNewInstance(currentState, key, arg);
            System.out.println("Create new State (" + (this.states.size() + 1) + "): " + currentState);
            this.states.add(new WeakReference<PropertyState>(currentState));
            return currentState;
        }
    }

    public PropertyState getEmptyState() {
        return this.empty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PropertyState> getStates() {
        Manager manager = this;
        synchronized (manager) {
            ArrayList<PropertyState> ret = new ArrayList<PropertyState>();
            Iterator it = this.states.iterator();
            while (it.hasNext()) {
                PropertyState existing = (PropertyState)((WeakReference)it.next()).get();
                if (existing == null) {
                    it.remove();
                    continue;
                }
                ret.add(existing);
            }
            return ret;
        }
    }

    public Map<String, Object> toIndexMap(PropertyState state) {
        if (state.size() == 0) {
            return EMPTY_MAP;
        }
        PropertyStateIndexCache cache = this.threadIndexCache.get();
        if (cache == null) {
            throw new IllegalStateException("No Cache Controller is set for this thread/Manager");
        }
        return cache.toMap(state);
    }

    public void setThreadIndexCache(PropertyStateIndexCache cache) {
        this.threadIndexCache.set(cache);
    }
}

