/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.commonInterface;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.HashSet;
import org.appwork.exceptions.WTFException;
import org.appwork.serializer.SC;
import org.appwork.storage.TypeRef;
import org.appwork.storage.commonInterface.SerializerException;
import org.appwork.storage.commonInterface.SerializerInterface;

public abstract class AbstractSerializer
implements SerializerInterface {
    @Override
    public byte[] toByteArray(Object o, Object ... context) throws SerializerException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.toStream(o, bout, true, context);
            return bout.toByteArray();
        }
        catch (Exception e) {
            throw SerializerException.wrap(e);
        }
    }

    protected boolean contextContainsAll(Object[] context, Object ... query) {
        if (context == null) {
            return false;
        }
        HashSet<Object> set = new HashSet<Object>(Arrays.asList(query));
        for (Object o : context) {
            set.remove(o);
            if (set.size() != 0) continue;
            return true;
        }
        return false;
    }

    public boolean isContextPretty(Object ... context) {
        boolean pretty = false;
        boolean noNewLine = false;
        for (Object c : context) {
            if (c == SC.READABLE || c == SC.CONFIG_FILE || c == SC.LOG_MULTILINE || c == SC.WITH_DOCUMENTATION || c == SC.LOG_MULTILINE) {
                pretty = true;
            }
            if (c != SC.SINGLE_LINE) continue;
            noNewLine = true;
        }
        if (pretty && noNewLine) {
            throw new WTFException("Missleading Serializer Context: " + Arrays.asList(context));
        }
        return pretty;
    }

    @Override
    public <T> T fromByteArray(byte[] byteArray, TypeRef<T> type, Object ... context) throws SerializerException {
        try {
            return this.fromStream(new ByteArrayInputStream(byteArray), type, new Object[0]);
        }
        catch (Exception e) {
            throw SerializerException.wrap(e);
        }
    }
}

