/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.config.handler;

import java.lang.annotation.Annotation;
import org.appwork.storage.Storage;
import org.appwork.storage.config.annotations.DefaultBooleanValue;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.storage.config.handler.StorageHandler;
import org.appwork.utils.StringUtils;

public class BooleanKeyHandler
extends KeyHandler<Boolean> {
    public BooleanKeyHandler(StorageHandler<?> storageHandler, String key) {
        super(storageHandler, key);
    }

    @Override
    protected Class<? extends Annotation> getDefaultAnnotation() {
        return DefaultBooleanValue.class;
    }

    @Override
    protected void initDefaults() throws Throwable {
        this.setDefaultValue(Boolean.FALSE);
    }

    @Override
    protected void initHandler() {
        this.setStorageSyncMode(this.getDefaultStorageSyncMode());
    }

    public boolean isEnabled() {
        Boolean value = (Boolean)this.getValue();
        return value != null && value != false;
    }

    @Override
    protected void putValue(Boolean object) {
        Storage storage = this.storageHandler.getPrimitiveStorage(this);
        if (storage != null) {
            storage.put(this.getKey(), object);
        }
    }

    public boolean toggle() {
        boolean n = !this.isEnabled();
        this.setValue(n);
        return n;
    }

    @Override
    protected boolean equals(Object x, Object y) {
        if (x == y) {
            return true;
        }
        if (x instanceof Boolean && y instanceof Boolean) {
            return x.equals(y);
        }
        return false;
    }

    @Override
    protected Boolean getValueStorage() {
        Object rawValue = this.getRawValueStorage();
        if (rawValue instanceof Boolean) {
            return (Boolean)rawValue;
        }
        if (rawValue instanceof String) {
            String stringValue = (String)rawValue;
            if (StringUtils.equalsIgnoreCase("true", stringValue) || StringUtils.equals("1", stringValue)) {
                return Boolean.TRUE;
            }
            if (StringUtils.equalsIgnoreCase("false", stringValue) || StringUtils.equals("0", stringValue)) {
                return Boolean.FALSE;
            }
            if (StringUtils.equalsIgnoreCase("null", stringValue)) {
                if (this.isRealPrimitive()) {
                    return Boolean.FALSE;
                }
                return null;
            }
        }
        return (Boolean)rawValue;
    }

    @Override
    protected void validateValue(Boolean object) throws Throwable {
    }
}

