/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.config.swing.models;

import java.awt.Toolkit;
import java.util.Comparator;
import java.util.List;
import javax.swing.SpinnerNumberModel;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.annotations.DoubleSpinnerValidator;
import org.appwork.storage.config.handler.DoubleKeyHandler;
import org.appwork.storage.config.swing.ValueProvider;
import org.appwork.storage.config.swing.ValueProviderListener;
import org.appwork.storage.config.swing.models.KeyHandlerProviderBridge;
import org.appwork.utils.CompareUtils;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.swing.EDTRunner;

public class ConfigDoubleSpinnerModel
extends SpinnerNumberModel
implements ValueProviderListener<Double> {
    private static final long serialVersionUID = 1L;
    private final ValueProvider<Double> provider;

    public ConfigDoubleSpinnerModel(DoubleKeyHandler keyHandler) {
        this(new KeyHandlerProviderBridge<Double>(keyHandler));
    }

    public ConfigDoubleSpinnerModel(ValueProvider<Double> provider) {
        this.provider = provider;
        provider.register(this, true);
        List<DoubleSpinnerValidator> spinn = provider.getAnnotations(DoubleSpinnerValidator.class);
        if (spinn != null && spinn.size() > 0) {
            this.setMinimum((Comparable)Double.valueOf(spinn.get(0).min()));
            this.setMaximum((Comparable)Double.valueOf(spinn.get(0).max()));
            this.setStepSize(spinn.get(0).step());
        }
    }

    public ValueProvider<Double> getProvider() {
        return this.provider;
    }

    public void setMinimum(Comparable minimum) {
        super.setMinimum(Double.valueOf(((Number)((Object)minimum)).doubleValue()));
    }

    public void setMaximum(Comparable maximum) {
        super.setMaximum(Double.valueOf(((Number)((Object)maximum)).doubleValue()));
    }

    @Override
    public void setStepSize(Number stepSize) {
        super.setStepSize(stepSize.doubleValue());
    }

    @Override
    public Number getNumber() {
        return this.getProvider().get();
    }

    @Override
    public Object getNextValue() {
        return this.incrValue(1.0);
    }

    @Override
    public Object getPreviousValue() {
        return this.incrValue(-1.0);
    }

    protected static <T extends Number> T incrValue(ConfigDoubleSpinnerModel model, Class<T> numClass, double i) {
        Comparator<Number> comparator;
        Double checkAgainst;
        double stepSize = model.getStepSize().doubleValue();
        Double current = ((Number)model.getValue()).doubleValue();
        Double maximum = ((Number)((Object)model.getMaximum())).doubleValue();
        Double minimum = ((Number)((Object)model.getMinimum())).doubleValue();
        if (i > 0.0) {
            if (((Number)current).intValue() == -1 && CompareUtils.compareNumber(current, minimum) == 0) {
                return (T)((Number)ReflectionUtils.cast(0, numClass));
            }
            checkAgainst = maximum;
            comparator = new Comparator<Number>(){

                @Override
                public int compare(Number o1, Number o2) {
                    return CompareUtils.compareNumber(o2, o1);
                }
            };
        } else {
            checkAgainst = minimum;
            comparator = new Comparator<Number>(){

                @Override
                public int compare(Number o1, Number o2) {
                    return CompareUtils.compareNumber(o1, o2);
                }
            };
        }
        double ret = current + stepSize * i;
        if (comparator.compare(ret, checkAgainst) < 0) {
            while (stepSize > 0.0) {
                stepSize = stepSize % 10.0 == 0.0 ? (stepSize /= 10.0) : (stepSize /= 2.0);
                double check = current + stepSize * i;
                if (comparator.compare(check, checkAgainst) < 0) continue;
                break;
            }
            if (stepSize == 0.0) {
                stepSize = 1.0;
            }
            ret = current + stepSize * i;
        }
        return (T)((Number)ReflectionUtils.cast(ret, numClass));
    }

    protected Number incrValue(double i) {
        return ConfigDoubleSpinnerModel.incrValue(this, Double.class, i);
    }

    @Override
    public Object getValue() {
        return this.getNumber();
    }

    @Override
    public void setValue(Object value) {
        block5: {
            try {
                if (value instanceof Number) {
                    this.getProvider().set(((Number)value).doubleValue());
                    break block5;
                }
                if (!(value instanceof String)) break block5;
                try {
                    this.getProvider().set(Double.valueOf(String.valueOf(value)));
                }
                catch (NumberFormatException e) {
                    throw new ValidationException(e);
                }
            }
            catch (ValidationException e) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    @Override
    public void onValueModified(ValueProvider<Double> owner, Double newValue) {
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                ConfigDoubleSpinnerModel.this.fireStateChanged();
            }
        };
    }

    @Override
    public void onValueValidationError(ValueProvider<Double> owner, Double invalidValue, Exception exception) {
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                ConfigDoubleSpinnerModel.this.fireStateChanged();
            }
        };
    }
}

