/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.flexijson;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.appwork.exceptions.WTFException;
import org.appwork.moncompare.CompareException;
import org.appwork.moncompare.Condition;
import org.appwork.moncompare.Scope;
import org.appwork.moncompare.fromjson.FlexiConditionMapper;
import org.appwork.storage.flexijson.FlexiComment;
import org.appwork.storage.flexijson.FlexiCommentJsonNode;
import org.appwork.storage.flexijson.FlexiJSONParser;
import org.appwork.storage.flexijson.FlexiJSonArray;
import org.appwork.storage.flexijson.FlexiJSonComments;
import org.appwork.storage.flexijson.FlexiJSonNode;
import org.appwork.storage.flexijson.FlexiJSonObject;
import org.appwork.storage.flexijson.FlexiJSonValue;
import org.appwork.storage.flexijson.FlexiParserException;
import org.appwork.storage.flexijson.FlexiUtils;
import org.appwork.storage.flexijson.InvalidPathException;
import org.appwork.storage.flexijson.KeyValueElement;
import org.appwork.storage.flexijson.mapper.FlexiMapperException;
import org.appwork.utils.ConcatIterator;
import org.appwork.utils.StringUtils;
import org.appwork.utils.reflection.Clazz;

public class JSPath
implements Iterable<Object> {
    private LinkedList<Object> elements = new LinkedList();
    public static final String COMMENT_PATH_PREFIX = "//#";

    public JSPath(List<? extends Object> subList) {
        this();
        this.elements.addAll(subList);
    }

    public JSPath(Object ... path) {
        this();
        this.elements.addAll(Arrays.asList(path));
    }

    public int hashCode() {
        return this.elements.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof JSPath) {
            JSPath other = (JSPath)obj;
            if (this.elements.equals(other.elements)) {
                return true;
            }
            if (this.elements.size() != other.elements.size()) {
                return false;
            }
            for (int i = 0; i < this.elements.size(); ++i) {
                if (StringUtils.equals(StringUtils.valueOfOrNull(this.elements.get(i)), StringUtils.valueOfOrNull(other.elements.get(i)))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public JSPath() {
    }

    @Override
    public Iterator<Object> iterator() {
        return this.elements.iterator();
    }

    public static JSPath fromPathString(String path) throws InvalidPathException {
        JSPath ret = new JSPath();
        if (path.startsWith(".")) {
            path = path.substring(1);
        }
        while (true) {
            String key = null;
            if ("".equals(path)) {
                return ret;
            }
            if (path.startsWith("[")) {
                try {
                    FlexiJSONParser parser = new FlexiJSONParser(path){}.setDebug(new StringBuilder());
                    parser.setBreakAtEndOfObject(true);
                    parser.setIgnoreIssues(FlexiJSONParser.IGNORE_LIST_JS);
                    FlexiJSonNode parsed = (FlexiJSonNode)((FlexiJSonArray)parser.parse()).get(0);
                    if (parsed instanceof FlexiJSonValue) {
                        FlexiJSonValue token = (FlexiJSonValue)parsed;
                        ret.add(token.getValue());
                        path = parser.isEndOfStreamReached() ? path.substring(parser.index) : path.substring(parser.index - 1);
                        if (!path.startsWith(".")) continue;
                        path = path.substring(1);
                        continue;
                    }
                    if (parsed instanceof FlexiJSonObject) {
                        try {
                            ret.add(new FlexiConditionMapper<Condition>(Condition.class).jsonToObject(parsed, Condition.TYPE));
                        }
                        catch (FlexiMapperException e) {
                            throw new InvalidPathException(e);
                        }
                        path = parser.isEndOfStreamReached() ? path.substring(parser.index) : path.substring(parser.index - 1);
                        if (!path.startsWith(".")) continue;
                        path = path.substring(1);
                        continue;
                    }
                    throw new InvalidPathException("Invalid []-escaping");
                }
                catch (FlexiParserException e) {
                    throw new InvalidPathException(e);
                }
            }
            int pointIndex = path.indexOf(".");
            int parenthesisIndexIndex = path.indexOf("[");
            if (pointIndex < 0 && parenthesisIndexIndex < 0) {
                ret.add(path);
                return ret;
            }
            if (parenthesisIndexIndex > 0 && (parenthesisIndexIndex < pointIndex || pointIndex < 0)) {
                key = path.substring(0, parenthesisIndexIndex);
                ret.add(key);
                path = path.substring(parenthesisIndexIndex);
                continue;
            }
            key = path.substring(0, pointIndex);
            ret.add(key);
            path = path.substring(pointIndex + 1);
        }
    }

    public static JSPath fromFlexiNode(FlexiJSonNode org) {
        if (org == null) {
            throw new IllegalArgumentException("Node is null");
        }
        FlexiJSonNode json = org;
        JSPath path = new JSPath();
        block0: while (json != null) {
            FlexiJSonNode parent = json.getParent();
            if (parent == json) {
                throw new WTFException("Bad Path");
            }
            if (parent == null) break;
            if (json instanceof FlexiComment) {
                int index;
                if (parent instanceof FlexiJSonComments) {
                    parent = parent.getParent();
                }
                if (parent instanceof FlexiJSonValue) {
                    index = 0;
                    for (FlexiCommentJsonNode flexiCommentJsonNode : new ConcatIterator(parent.getCommentsBefore(), parent.getCommentsAfter())) {
                        if (flexiCommentJsonNode == json) {
                            path.add(0, COMMENT_PATH_PREFIX + index);
                            json = parent;
                            continue block0;
                        }
                        ++index;
                    }
                    parent = parent.getParent();
                }
                if (parent instanceof FlexiJSonObject) {
                    ArrayList<FlexiJSonComments> collect = new ArrayList<FlexiJSonComments>();
                    collect.add(((FlexiJSonObject)parent).getCommentsBefore());
                    collect.add(((FlexiJSonObject)parent).getCommentsInside());
                    for (KeyValueElement keyValueElement : ((FlexiJSonObject)parent).getElements()) {
                        if (keyValueElement.getCommentsBeforeKey() != null) {
                            collect.add(keyValueElement.getCommentsBeforeKey());
                        }
                        if (keyValueElement.getCommentsAfterKey() == null) continue;
                        collect.add(keyValueElement.getCommentsAfterKey());
                    }
                    collect.add(((FlexiJSonObject)parent).getCommentsAfter());
                    int index2 = 0;
                    for (FlexiCommentJsonNode c : new ConcatIterator(collect.toArray(new FlexiJSonComments[0]))) {
                        if (c == json) {
                            path.add(0, COMMENT_PATH_PREFIX + index2);
                            json = parent;
                            continue block0;
                        }
                        ++index2;
                    }
                } else if (parent instanceof FlexiJSonArray) {
                    index = 0;
                    for (FlexiCommentJsonNode flexiCommentJsonNode : new ConcatIterator(((FlexiJSonArray)parent).getCommentsBefore(), ((FlexiJSonArray)parent).getCommentsInside(), ((FlexiJSonArray)parent).getCommentsAfter())) {
                        if (flexiCommentJsonNode == json) {
                            path.add(0, COMMENT_PATH_PREFIX + index);
                            json = parent;
                            continue block0;
                        }
                        ++index;
                    }
                }
                throw new WTFException("Bad Path");
            }
            if (parent instanceof FlexiJSonObject) {
                for (KeyValueElement e : ((FlexiJSonObject)parent).getElements()) {
                    if (e.getValue() != json) continue;
                    json = parent;
                    path.add(0, e.getKey());
                    continue block0;
                }
                throw new WTFException("Bad Path");
            }
            if (parent instanceof FlexiJSonArray) {
                for (int i = 0; i < ((FlexiJSonArray)parent).size(); ++i) {
                    if (((FlexiJSonArray)parent).get(i) != json) continue;
                    path.add(0, i);
                    json = parent;
                    continue block0;
                }
                throw new WTFException("Bad Path");
            }
            if (parent instanceof FlexiJSonValue) {
                throw new WTFException("Bad Path");
            }
            throw new WTFException("Unknown entry");
        }
        return path;
    }

    public JSPath add(int i, Object element) {
        this.elements.add(i, element);
        return this;
    }

    @Deprecated
    public String toPathString() {
        return this.toPathString(true);
    }

    public String toPathString(boolean leadingPoint) {
        StringBuilder sb = new StringBuilder();
        for (Object e : this.elements) {
            if (JSPath.isArrayKey(e)) {
                sb.append("[" + e + "]");
                continue;
            }
            if (e instanceof String) {
                if (((String)e).matches("//\\#\\d+") && e == this.getLast()) {
                    sb.append(".");
                    sb.append(e);
                    continue;
                }
                if (!String.valueOf(e).matches("^[a-zA-Z_$][a-zA-Z_$0-9]*$")) {
                    try {
                        sb.append("[" + FlexiUtils.serializeMinimized(e) + "]");
                        continue;
                    }
                    catch (FlexiMapperException e2) {
                        throw new WTFException(e2);
                    }
                }
                sb.append(".");
                sb.append(e);
                continue;
            }
            if (e instanceof Condition) {
                sb.append("[" + FlexiUtils.serializeMinimizedWithWTF(e) + "]");
                continue;
            }
            throw new WTFException("Unsupported Path entry");
        }
        String ret = sb.toString();
        if (!leadingPoint && ret.startsWith(".")) {
            return ret.substring(1);
        }
        return ret;
    }

    public Object getLast() {
        return this.elements.getLast();
    }

    public String toString() {
        return "JSPath:" + this.toPathString(true);
    }

    public JSPath getParent() {
        try {
            if (this.size() == 0) {
                return null;
            }
            JSPath ret = new JSPath(this.elements.subList(0, this.size() - 1));
            return ret;
        }
        catch (IllegalArgumentException e) {
            throw new WTFException(e);
        }
    }

    public int size() {
        return this.elements.size();
    }

    public JSPath derive(Object key) {
        JSPath ret = new JSPath(this.elements);
        ret.add(key);
        return ret;
    }

    public JSPath append(JSPath path) {
        JSPath ret = new JSPath(this.elements);
        ret.elements.addAll(path.elements);
        return ret;
    }

    public JSPath add(Object key) {
        this.elements.add(key);
        return this;
    }

    public List<Object> getElements() {
        return Collections.unmodifiableList(this.elements);
    }

    public Object getFirst() {
        return this.elements.get(0);
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public JSPath withPrefix(String path) throws InvalidPathException {
        JSPath ret = JSPath.fromPathString(path);
        ret.elements.addAll(this.elements);
        return ret;
    }

    public boolean startsWith(JSPath path) {
        if (path.size() > this.size()) {
            return false;
        }
        for (int i = 0; i < path.size(); ++i) {
            if (String.valueOf(this.elements.get(i)).equals(String.valueOf(path.elements.get(i)))) continue;
            return false;
        }
        return true;
    }

    public static JSPath getNE(String string) {
        try {
            return JSPath.fromPathString(string);
        }
        catch (InvalidPathException e) {
            throw new WTFException(e);
        }
    }

    public static JSPath fromPathElements(Object ... elements) {
        return new JSPath(Arrays.asList(elements));
    }

    public static boolean isArrayKey(Object e) {
        if (e == null) {
            return false;
        }
        if (Clazz.isFixedPointNumber(e.getClass())) {
            return true;
        }
        return String.valueOf(e).matches("^[0-9]+$");
    }

    public static int toArrayIndex(Object e) throws NumberFormatException {
        return e instanceof Number ? ((Number)e).intValue() : Integer.parseInt(String.valueOf(e));
    }

    public Object resolve(Object o) throws CompareException {
        return new Condition().resolveKeyPath(new Scope(o), this).getLast();
    }

    public Object get(int index) {
        if (index < 0) {
            index = this.size() + index;
        }
        return this.elements.get(index);
    }
}

