/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.mapper;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.appwork.storage.AdapterSelfJSONDeSerializer;
import org.appwork.storage.AdapterSelfJSONSerializer;
import org.appwork.storage.DeSerializerInput;
import org.appwork.storage.JSONMapper;
import org.appwork.storage.JSonMapperException;
import org.appwork.storage.JsonDeSerializer;
import org.appwork.storage.JsonSerializer;
import org.appwork.storage.SelfJSONDeSerializer;
import org.appwork.storage.SelfJSONSerializer;
import org.appwork.storage.TypeRef;
import org.appwork.storage.converter.AdapterSelfJSONConverterForDeserialization;
import org.appwork.storage.converter.AdapterSelfJSONConverterForSerialization;
import org.appwork.storage.converter.ConverterInput;
import org.appwork.storage.converter.JsonConverterForDeserialization;
import org.appwork.storage.converter.JsonConverterForSerialization;
import org.appwork.storage.converter.SelfJsonConverterForDeserialization;
import org.appwork.storage.converter.SelfJsonConverterForSerialization;
import org.appwork.utils.CompareUtils;
import org.appwork.utils.IO;
import org.appwork.utils.ReflectionUtils;

public abstract class AbstractJsonMapper
implements JSONMapper {
    protected static final Charset UTF8 = Charset.forName("UTF-8");
    protected volatile HashMap<Class<?>, JsonSerializer> serializer = new HashMap();
    protected volatile HashMap<Class<?>, JsonDeSerializer> deSerializer = new HashMap();
    protected volatile HashMap<Class<?>, JsonConverterForSerialization> convertForSerialization = new HashMap();
    protected volatile HashMap<Class<?>, JsonConverterForDeserialization> convertForDeserialization = new HashMap();
    private HashMap<Class<?>, HashMap<Class<?>, List<?>>> findBestTypeMatchCache = new HashMap();

    public AbstractJsonMapper() {
        this.initMapper();
    }

    protected void initMapper() {
        this.putSerializer(SelfJSONSerializer.class, new AdapterSelfJSONSerializer());
        this.putDeSerializer(SelfJSONDeSerializer.class, new AdapterSelfJSONDeSerializer());
        this.putConverterForSerialization(SelfJsonConverterForSerialization.class, new AdapterSelfJSONConverterForSerialization());
        this.putConverterFromDeserialization(SelfJsonConverterForDeserialization.class, new AdapterSelfJSONConverterForDeserialization());
    }

    protected Class<?> getRawTypeForDeserialization(Type type) {
        Class<Object> raw = ReflectionUtils.getRaw(type);
        if (raw == null) {
            raw = Object.class;
        }
        return raw;
    }

    @Override
    public synchronized JsonConverterForSerialization putConverterForSerialization(Class<?> clazz, JsonConverterForSerialization converter) {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz is null");
        }
        HashMap newMap = new HashMap();
        newMap.putAll(this.convertForSerialization);
        JsonConverterForSerialization old = converter == null ? (JsonConverterForSerialization)newMap.remove(clazz) : newMap.put(clazz, converter);
        this.convertForSerialization = newMap;
        this.resetBestMatchCache();
        return old;
    }

    public int getHirarchyDepths(Class<?> assignable, Class<?> target) {
        int ret = 0;
        Class<?> now = target;
        while (now != null && now != assignable) {
            Class<?>[] interfaces = now.getInterfaces();
            if (interfaces != null) {
                int bestIntRet = -1;
                for (Class<?> i : now.getInterfaces()) {
                    if (!assignable.isAssignableFrom(i)) continue;
                    int intRet = 0;
                    while (i != null) {
                        ++intRet;
                        if (i == assignable) break;
                        i = i.getSuperclass();
                    }
                    if (bestIntRet >= 0 && bestIntRet <= intRet) continue;
                    bestIntRet = intRet;
                }
                if (bestIntRet >= 0) {
                    return ret += bestIntRet;
                }
            }
            now = now.getSuperclass();
            ret += 100;
            ret = 100 * (ret / 100);
        }
        return ret;
    }

    protected String handleSerializationMatches(Object input, List<JsonSerializer> matches) {
        for (JsonSerializer best : matches) {
            String ret = best.toJSonString(input, this);
            if (ret == JsonSerializer.SKIP || ret == input) continue;
            return ret;
        }
        return JsonSerializer.SKIP;
    }

    protected Object handleSerializationConverterMatches(Object input, List<JsonConverterForSerialization> matches) {
        for (JsonConverterForSerialization best : matches) {
            Object ret = best.convertForSerialization(input, this);
            if (ret == JsonConverterForSerialization.SKIP || ret == input) continue;
            return ret;
        }
        return input;
    }

    protected Object handleDeserializationMatches(DeSerializerInput input, TypeRef<Object> typeRef, List<JsonDeSerializer> matches) {
        for (JsonDeSerializer best : matches) {
            Object ret = best.toObject(input, typeRef, this);
            if (ret == JsonDeSerializer.SKIP || ret == input) continue;
            return ret;
        }
        return input;
    }

    protected Object handleDeserializationConverterMatches(ConverterInput input, TypeRef<Object> typeRef, List<JsonConverterForDeserialization> matches) {
        for (JsonConverterForDeserialization best : matches) {
            Object ret = best.convertForDeserialization(input, typeRef, this);
            if (ret == JsonConverterForDeserialization.SKIP || ret instanceof ConverterInput) continue;
            return ret;
        }
        return input;
    }

    @Override
    public synchronized JsonConverterForDeserialization putConverterFromDeserialization(Class<?> clazz, JsonConverterForDeserialization converter) {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz is null");
        }
        HashMap newMap = new HashMap();
        newMap.putAll(this.convertForDeserialization);
        JsonConverterForDeserialization old = converter == null ? (JsonConverterForDeserialization)newMap.remove(clazz) : newMap.put(clazz, converter);
        this.convertForDeserialization = newMap;
        this.resetBestMatchCache();
        return old;
    }

    @Override
    public synchronized JsonDeSerializer putDeSerializer(Class<?> clazz, JsonDeSerializer jsonDeSerializer) {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz is null");
        }
        HashMap newMap = new HashMap();
        newMap.putAll(this.deSerializer);
        JsonDeSerializer old = jsonDeSerializer == null ? (JsonDeSerializer)newMap.remove(clazz) : newMap.put(clazz, jsonDeSerializer);
        this.deSerializer = newMap;
        this.resetBestMatchCache();
        return old;
    }

    @Override
    public synchronized JsonSerializer putSerializer(Class<?> clazz, JsonSerializer jsonSerializer) {
        HashMap newMap = new HashMap();
        newMap.putAll(this.serializer);
        JsonSerializer old = jsonSerializer == null ? (JsonSerializer)newMap.remove(clazz) : newMap.put(clazz, jsonSerializer);
        this.serializer = newMap;
        this.resetBestMatchCache();
        return old;
    }

    protected void resetBestMatchCache() {
        this.findBestTypeMatchCache = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected <T> List<T> findBestTypeMatch(Class<?> raw, HashMap<Class<?>, T> lookup, Class<T> type) {
        LinkedList ret;
        if (lookup.size() == 0) {
            return null;
        }
        HashMap<Class<?>, HashMap<Class<?>, List<?>>> hashMap = this.findBestTypeMatchCache;
        synchronized (hashMap) {
            HashMap<Class<?>, List<?>> map = this.findBestTypeMatchCache.get(type);
            if (map != null && (ret = map.get(raw)) != null) {
                return ret;
            }
        }
        T best = lookup.get(Object.class);
        ArrayList<KeyValue<T>> tmp = new ArrayList<KeyValue<T>>();
        if (best != null) {
            tmp.add(new KeyValue<T>(raw, Object.class, best));
        }
        if (lookup.size() > 0) {
            for (Map.Entry hashMap2 : lookup.entrySet()) {
                if (hashMap2.getKey() == raw) {
                    tmp.add(new KeyValue(raw, (Class)hashMap2.getKey(), hashMap2.getValue()));
                    continue;
                }
                if (hashMap2.getKey() == null || raw == null || !((Class)hashMap2.getKey()).isAssignableFrom(raw)) continue;
                tmp.add(new KeyValue(raw, (Class)hashMap2.getKey(), hashMap2.getValue()));
            }
        }
        Collections.sort(tmp, new Comparator<KeyValue<T>>(){

            @Override
            public int compare(KeyValue<T> o1, KeyValue<T> o2) {
                return CompareUtils.compare(o1.getTypeHirarchyDepths(), o2.getTypeHirarchyDepths());
            }
        });
        ret = new LinkedList();
        for (KeyValue keyValue : tmp) {
            ret.add(keyValue.value);
        }
        HashMap<Class<?>, HashMap<Class<?>, List<?>>> hashMap2 = this.findBestTypeMatchCache;
        synchronized (hashMap2) {
            void var8_14;
            HashMap<Class<?>, List<?>> hashMap3 = this.findBestTypeMatchCache.get(type);
            if (hashMap3 == null) {
                HashMap hashMap4 = new HashMap();
                this.findBestTypeMatchCache.put(type, hashMap4);
            }
            var8_14.put(raw, ret);
        }
        return ret;
    }

    @Override
    public byte[] objectToByteArray(Object value) throws JSonMapperException {
        String ret = this.objectToString(value);
        if (ret == null) {
            return "null".getBytes(UTF8);
        }
        return ret.getBytes(UTF8);
    }

    @Override
    public void writeObject(OutputStream outputStream, Object value) throws JSonMapperException {
        try {
            try {
                outputStream.write(this.objectToByteArray(value));
            }
            finally {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
        }
        catch (IOException e) {
            throw new JSonMapperException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T inputStreamToObject(InputStream inputStream, TypeRef<T> type) throws JSonMapperException {
        try {
            try {
                T t = this.byteArrayToObject(IO.readStream(-1, inputStream), type);
                return t;
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (IOException e) {
            throw new JSonMapperException(e);
        }
    }

    @Override
    public <T> T byteArrayToObject(byte[] byteArray, TypeRef<T> type) throws JSonMapperException {
        try {
            return this.stringToObject(IO.BOM.read(byteArray, UTF8), type);
        }
        catch (IOException e) {
            throw new JSonMapperException(e);
        }
    }

    @Override
    public <T> T byteArrayToObject(byte[] byteArray, Class<T> clazz) throws JSonMapperException {
        try {
            return this.stringToObject(IO.BOM.read(byteArray, UTF8), clazz);
        }
        catch (IOException e) {
            throw new JSonMapperException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T inputStreamToObject(InputStream inputStream, Class<T> clazz) throws JSonMapperException {
        try {
            try {
                T t = this.byteArrayToObject(IO.readStream(-1, inputStream), clazz);
                return t;
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (IOException e) {
            throw new JSonMapperException(e);
        }
    }

    public class KeyValue<T> {
        private Class<?> target;
        public Class<?> key;
        public T value;
        private int depths = -1;

        public KeyValue(Class<?> target, Class<?> key, T value) {
            this.key = key;
            this.value = value;
            this.target = target;
        }

        public int getTypeHirarchyDepths() {
            if (this.depths < 0) {
                this.depths = AbstractJsonMapper.this.getHirarchyDepths(this.key, this.target);
            }
            return this.depths;
        }
    }
}

