/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.tests;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.appwork.exceptions.WTFException;
import org.appwork.utils.Files;
import org.appwork.utils.ZipContentHasher;

public abstract class ClassPathScanner<E extends Throwable> {
    public abstract void handle(Class<?> var1) throws E;

    public static List<URL> getClassPath() {
        return ClassPathScanner.getClassPath(Thread.currentThread().getContextClassLoader());
    }

    public static List<URL> getBootClassPath() {
        ArrayList<URL> urls = new ArrayList<URL>();
        String classPath = System.getProperty("sun.boot.class.path");
        if (classPath != null) {
            String[] classPathEntries;
            for (String classPathEntry : classPathEntries = classPath.split(File.pathSeparator)) {
                try {
                    urls.add(new File(classPathEntry).toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new WTFException(e);
                }
            }
        }
        return urls;
    }

    public static List<URL> getClassPath(ClassLoader cl) {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (cl instanceof URLClassLoader) {
            urls.addAll(Arrays.asList(((URLClassLoader)cl).getURLs()));
        } else {
            String[] classPathEntries;
            String classPath = System.getProperty("java.class.path");
            for (String classPathEntry : classPathEntries = classPath.split(File.pathSeparator)) {
                try {
                    urls.add(new File(classPathEntry).toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new WTFException(e);
                }
            }
        }
        if (urls.size() == 0) {
            throw new WTFException("empty classPath?!");
        }
        return urls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws E {
        for (URL url : ClassPathScanner.getClassPath()) {
            try {
                Class<?> cls;
                File root = new File(url.toURI());
                if (root.isDirectory()) {
                    List<File> files = Files.getFiles(true, true, root);
                    for (File file : files) {
                        String rel = Files.getRelativePath(root, file);
                        if (!file.isFile() || !rel.toUpperCase(Locale.ROOT).endsWith(".CLASS")) continue;
                        cls = null;
                        try {
                            cls = Class.forName(rel.replace("/", ".").substring(0, rel.length() - ".class".length()), false, Thread.currentThread().getContextClassLoader());
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (cls == null) continue;
                        this.handle(cls);
                    }
                    continue;
                }
                if (!root.isFile() || !root.getName().toUpperCase(Locale.ROOT).endsWith(".JAR")) continue;
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(root);
                    for (Map.Entry entry : ZipContentHasher.getHashes("", fis, new ZipContentHasher.Customizer(){

                        @Override
                        public boolean handle(String path, ZipInputStream zipStream, ZipEntry entry, HashMap<String, byte[]> results) throws IOException {
                            return path.endsWith(".class");
                        }
                    }, false).entrySet()) {
                        String classname;
                        if (!((String)entry.getKey()).endsWith(".class") || (classname = ((String)entry.getKey()).replaceAll("[\\/\\\\]", ".").replaceAll("\\.class$", "")).startsWith("net.miginfocom.") || classname.startsWith("org.slf4j.") || classname.startsWith("org.tmatesoft.") || classname.startsWith("com.") || classname.startsWith("de.") || classname.startsWith("org.eclipse.") || classname.startsWith("org.tukaani.") || classname.startsWith("cx.") || classname.startsWith("org.freedesktop.") || classname.startsWith("net.sf.sevenzipjbinding.") || classname.startsWith("org.junit.") || classname.startsWith("org.fourthline.") || classname.startsWith("META-INF.") || classname.startsWith("org.bouncycastle.") || classname.startsWith("org.mozilla.") || classname.startsWith("net.sourceforge.") || classname.startsWith("net.sf.") || classname.startsWith("org.antlr.") || classname.startsWith("jsyntaxpane.") || classname.startsWith("org.seamless.") || classname.startsWith("org.brotli.") || classname.startsWith("org.hamcrest.") || classname.startsWith("junit.") || classname.startsWith("dbus") || classname.startsWith("org.schwering.") || classname.startsWith("net.lingala.") || classname.startsWith("module-info")) continue;
                        cls = null;
                        try {
                            cls = Class.forName(classname);
                        }
                        catch (Throwable e) {
                            continue;
                        }
                        this.handle(cls);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        if (fis == null) continue;
                        fis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (URISyntaxException e1) {
                e1.printStackTrace();
            }
        }
    }
}

