/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.components;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import org.appwork.resources.AWUTheme;
import org.appwork.swing.action.BasicAction;
import org.appwork.swing.components.tooltips.ExtTooltip;
import org.appwork.swing.components.tooltips.ToolTipController;
import org.appwork.swing.components.tooltips.ToolTipHandler;
import org.appwork.swing.components.tooltips.TooltipFactory;
import org.appwork.swing.components.tooltips.TooltipTextDelegateFactory;
import org.appwork.utils.KeyUtils;
import org.appwork.utils.StringUtils;

public class ExtButton
extends JButton
implements ToolTipHandler {
    private static final long serialVersionUID = -7151290227825542967L;
    private TooltipFactory tooltipFactory = new TooltipTextDelegateFactory(this);
    private MouseAdapter rollOverlistener;
    private KeyStroke accelerator;
    private int calculatingPrefSize = 0;
    private Icon disabledIcon = null;

    public ExtButton() {
        this((AbstractAction)null);
    }

    @Override
    protected void actionPropertyChanged(Action action, String propertyName) {
        super.actionPropertyChanged(action, propertyName);
        if (propertyName == "AcceleratorKey") {
            this.setAccelerator((KeyStroke)action.getValue("AcceleratorKey"));
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension withoutIcon;
        if (this.getIcon() == null || this.getVerticalTextPosition() != 0) {
            return super.getPreferredSize();
        }
        ++this.calculatingPrefSize;
        try {
            withoutIcon = super.getPreferredSize();
            if (super.getIcon() == null) {
                Dimension dimension = withoutIcon;
                return dimension;
            }
        }
        finally {
            --this.calculatingPrefSize;
        }
        Dimension withIcon = super.getPreferredSize();
        withIcon.height = withoutIcon.height;
        return withIcon;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Icon getIcon() {
        if (this.calculatingPrefSize > 0) {
            return null;
        }
        return super.getIcon();
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
    }

    public ExtButton(AbstractAction action) {
        super(action);
        if (!StringUtils.isEmpty(this.getToolTipText())) {
            this.setTooltipsEnabled(true);
        }
        if (action instanceof BasicAction) {
            if (((BasicAction)action).getTooltipFactory() != null) {
                this.tooltipFactory = ((BasicAction)action).getTooltipFactory();
                this.setTooltipsEnabled(true);
            }
            if (!StringUtils.isEmpty(((BasicAction)action).getTooltipText())) {
                this.setTooltipsEnabled(true);
            }
            this.setAccelerator((KeyStroke)action.getValue("AcceleratorKey"));
        }
    }

    public void setAccelerator(KeyStroke newAccelerator) {
        InputMap inputmap = this.getInputMap(2);
        if (this.accelerator != null) {
            inputmap.remove(newAccelerator);
            this.getActionMap().remove(KeyUtils.getShortcutString(this.accelerator, true));
            this.accelerator = null;
            this.setTooltipsEnabled(StringUtils.isNotEmpty(this.getToolTipText()));
        }
        if (newAccelerator != null) {
            this.accelerator = newAccelerator;
            String shortcutString = KeyUtils.getShortcutString(newAccelerator, true);
            inputmap.put(newAccelerator, shortcutString);
            this.setTooltipsEnabled(true);
            this.getActionMap().put(shortcutString, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExtButton.this.doClick();
                }
            });
        }
    }

    @Override
    public ExtTooltip createExtTooltip(Point mousePosition) {
        return this.getTooltipFactory().createTooltip();
    }

    public TooltipFactory getTooltipFactory() {
        TooltipFactory ret;
        if (this.getAction() instanceof BasicAction && (ret = ((BasicAction)this.getAction()).getTooltipFactory()) != null) {
            return ret;
        }
        return this.tooltipFactory;
    }

    @Override
    public String getToolTipText() {
        String ret = super.getToolTipText();
        if ((ret == null || "".equals(ret)) && this.getAction() instanceof BasicAction) {
            ret = ((BasicAction)this.getAction()).getTooltipText();
        }
        if (this.accelerator != null) {
            if (ret == null) {
                ret = "";
            }
            if (ret.length() > 0) {
                ret = ret + " ";
            }
            ret = ret + "[" + KeyUtils.getShortcutString(this.accelerator, true) + "]";
        }
        return ret;
    }

    @Override
    public boolean isTooltipDisabledUntilNextRefocus() {
        return true;
    }

    @Override
    public boolean isTooltipWithoutFocusEnabled() {
        return true;
    }

    protected void onRollOut() {
        this.setContentAreaFilled(false);
    }

    protected void onRollOver() {
        this.setContentAreaFilled(true);
    }

    public void setRolloverEffectEnabled(boolean b) {
        if (b) {
            if (this.rollOverlistener == null) {
                this.rollOverlistener = new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        ExtButton.this.onRollOver();
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        ExtButton.this.onRollOut();
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        ExtButton.this.onReleased();
                    }
                };
            }
            this.addMouseListener(this.rollOverlistener);
            this.onRollOut();
        } else if (this.rollOverlistener != null) {
            this.removeMouseListener(this.rollOverlistener);
            this.rollOverlistener = null;
        }
    }

    @Override
    public Icon getDisabledIcon() {
        if (this.disabledIcon == null) {
            this.disabledIcon = AWUTheme.I().getDisabledIcon(this.getIcon());
            if (this.disabledIcon != null) {
                this.firePropertyChange("disabledIcon", null, this.disabledIcon);
            }
        }
        return this.disabledIcon;
    }

    protected void onReleased() {
    }

    public void setTooltipFactory(TooltipFactory tooltipFactory) {
        this.tooltipFactory = tooltipFactory;
        ToolTipController.getInstance().register(this);
    }

    public ExtButton setTooltipsEnabled(boolean b) {
        if (b) {
            ToolTipController.getInstance().register(this);
        } else {
            ToolTipController.getInstance().unregister(this);
        }
        return this;
    }

    @Override
    public void setToolTipText(String text) {
        this.putClientProperty("ToolTipText", text);
        this.setTooltipsEnabled(StringUtils.isNotEmpty(this.getToolTipText()));
    }

    @Override
    public int getTooltipDelay(Point mousePositionOnScreen) {
        return 0;
    }

    @Override
    public boolean updateTooltip(ExtTooltip activeToolTip, MouseEvent e) {
        return false;
    }
}

