/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.components.circlebar;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import javax.swing.Icon;
import org.appwork.swing.components.circlebar.CircledProgressBar;
import org.appwork.swing.components.circlebar.IconPainter;

public class ImagePainter
implements IconPainter {
    private final Icon image;
    private final AlphaComposite composite;
    private Color foreground;
    private Color background;
    private Dimension preferredSize;

    public ImagePainter(Icon image) {
        this(image, 1.0f);
    }

    public ImagePainter(Icon image2, AlphaComposite instance) {
        this.image = image2;
        this.composite = instance;
        this.preferredSize = new Dimension(this.image.getIconWidth(), this.image.getIconHeight());
    }

    public ImagePainter(Icon image2, float alpha) {
        this(image2, AlphaComposite.getInstance(3, alpha));
    }

    public Color getBackground() {
        return this.background;
    }

    public AlphaComposite getComposite() {
        return this.composite;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public Icon getImage() {
        return this.image;
    }

    @Override
    public void paint(CircledProgressBar bar, Graphics2D g2, Shape shape, int diameter, double progress) {
        Composite comp = g2.getComposite();
        if (this.composite != null) {
            g2.setComposite(this.composite);
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Area a = null;
        if (this.getBackground() != null) {
            if (a == null) {
                Ellipse2D.Float circle = new Ellipse2D.Float(-(diameter - 2) / 2, -(diameter - 2) / 2, diameter - 2, diameter - 2);
                a = new Area(circle);
                a.intersect(new Area(shape));
            }
            g2.setColor(this.getBackground());
            g2.fill(a);
        }
        g2.setClip(shape);
        Dimension dim = bar.getSize();
        this.image.paintIcon(bar, g2, -this.image.getIconWidth() / 2, -this.image.getIconHeight() / 2);
        g2.setClip(null);
        if (this.getForeground() != null) {
            if (a == null) {
                Ellipse2D.Float circle = new Ellipse2D.Float(-(diameter - 2) / 2, -(diameter - 2) / 2, diameter - 2, diameter - 2);
                a = new Area(circle);
                a.intersect(new Area(shape));
            }
            g2.setStroke(new BasicStroke(1.0f, 1, 1));
            g2.setColor(this.getForeground());
            g2.draw(a);
        }
        if (this.composite != null) {
            g2.setComposite(comp);
        }
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    public void setForeground(Color foreground) {
        this.foreground = foreground;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredSize;
    }
}

