/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.exttable.columns;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.appwork.swing.MigPanel;
import org.appwork.swing.exttable.columns.ExtComponentColumn;
import org.appwork.utils.swing.SwingUtils;

public abstract class ExtFileBrowser<T>
extends ExtComponentColumn<T>
implements ActionListener {
    private static final long serialVersionUID = -6538541922869223568L;
    protected MigPanel renderer;
    private JTextField rendererLabel;
    private JButton rendererButton = new JButton("Browse");
    protected MigPanel editor;
    private JButton editorButton;
    private JTextField editorLabel;
    private T editObject;
    private Color bg;
    private Color fg;

    @Override
    public void actionPerformed(ActionEvent e) {
        this.getModel().setSelectedObject(this.editObject);
        File newFile = this.browse(this.editObject);
        this.setFile(this.editObject, newFile);
        this.cancelCellEditing();
    }

    protected abstract void setFile(T var1, File var2);

    public abstract File browse(T var1);

    public ExtFileBrowser(String name) {
        super(name);
        this.rendererLabel = new JTextField();
        this.rendererLabel.setEditable(false);
        SwingUtils.setOpaque(this.rendererLabel, false);
        this.rendererLabel.setBorder(null);
        this.renderer = new MigPanel("ins 0", "[grow,fill]0[]", "[grow,fill]"){
            private static final long serialVersionUID = -2099450346231216292L;

            @Override
            public void setForeground(Color fg) {
                super.setForeground(fg);
                ExtFileBrowser.this.rendererLabel.setForeground(fg);
            }

            @Override
            public void setBackground(Color bg) {
                super.setBackground(bg);
            }

            @Override
            public void setVisible(boolean aFlag) {
                ExtFileBrowser.this.rendererLabel.setVisible(aFlag);
                ExtFileBrowser.this.rendererButton.setVisible(aFlag);
            }
        };
        this.renderer.setOpaque(false);
        this.renderer.add(this.rendererLabel);
        this.renderer.add(this.rendererButton);
        this.bg = this.rendererLabel.getBackground();
        this.fg = this.rendererLabel.getForeground();
        this.editorButton = new JButton("Browse");
        this.editorButton.addActionListener(this);
        this.editorLabel = new JTextField();
        this.editorLabel.setEditable(false);
        SwingUtils.setOpaque(this.editorLabel, false);
        this.editorLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ExtFileBrowser.this.getModel().setSelectedObject(ExtFileBrowser.this.editObject);
            }
        });
        this.editorLabel.setBorder(null);
        this.editor = new MigPanel("ins 0", "[grow,fill]0[]", "[grow,fill]"){
            private static final long serialVersionUID = -8432598231289793141L;

            @Override
            public void setForeground(Color fg) {
                super.setForeground(fg);
                ExtFileBrowser.this.editorLabel.setForeground(fg);
            }

            @Override
            public void setVisible(boolean aFlag) {
                ExtFileBrowser.this.editorLabel.setVisible(aFlag);
                ExtFileBrowser.this.editorButton.setVisible(aFlag);
            }

            @Override
            public void setBackground(Color bg) {
                super.setBackground(bg);
            }
        };
        this.editor.setOpaque(false);
        this.editor.add(this.editorLabel);
        this.editor.add(this.editorButton);
    }

    @Override
    protected JComponent getInternalEditorComponent(T value, boolean isSelected, int row, int column) {
        return this.editor;
    }

    @Override
    protected JComponent getInternalRendererComponent(T value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.renderer;
    }

    @Override
    public void configureEditorComponent(T value, boolean isSelected, int row, int column) {
        this.editObject = value;
        this.editorLabel.setText(this.getFile(value) + "");
        this.editorLabel.setCaretPosition(0);
    }

    @Override
    public void configureRendererComponent(T value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.rendererLabel.setText(this.getFile(value) + "");
    }

    public abstract File getFile(T var1);

    @Override
    public void resetEditor() {
        this.editor.setForeground(this.fg);
        this.editor.setBackground(this.bg);
        this.editor.setOpaque(false);
    }

    @Override
    public void resetRenderer() {
        this.renderer.setForeground(this.fg);
        this.renderer.setBackground(this.bg);
        this.renderer.setOpaque(false);
    }
}

