/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.swing.exttable.columns;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.appwork.exceptions.WTFException;
import org.appwork.swing.MigPanel;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtDefaultRowSorter;
import org.appwork.swing.exttable.ExtTableModel;
import org.appwork.swing.exttable.renderercomponents.RendererProgressBar;
import org.appwork.utils.ColorUtils;
import org.appwork.utils.swing.renderer.RendererMigPanel;

public abstract class ExtProgressColumn<E>
extends ExtColumn<E> {
    private static final long serialVersionUID = -2473320164484034664L;
    protected RendererProgressBar determinatedRenderer;
    protected Border defaultBorder;
    protected RendererProgressBar indeterminatedRenderer;
    protected MigPanel renderer;
    private HashMap<E, Long> map;
    private int columnIndex = -1;
    protected MigPanel determinedRendererPanel;
    protected MigPanel indeterminedRendererPanel;
    protected RendererProgressBar rendererBar;

    public static double getPercentString(long current, long total) {
        if (total <= 0L) {
            return 0.0;
        }
        return (double)(current * 10000L / total) / 100.0;
    }

    public ExtProgressColumn(String title) {
        this(title, null);
    }

    protected MigPanel wrapDeterminedRenderer(RendererProgressBar renderer) {
        RendererMigPanel ret = new RendererMigPanel("ins 0 0 0 0", "[grow,fill]", "[grow,fill]");
        ret.add(renderer);
        return ret;
    }

    protected MigPanel wrapIndeterminedRenderer(RendererProgressBar renderer) {
        RendererMigPanel ret = new RendererMigPanel("ins 0 0 0 0", "[grow,fill]", "[grow,fill]");
        ret.add(renderer);
        return ret;
    }

    public ExtProgressColumn(String name, ExtTableModel<E> extModel) {
        super(name, extModel);
        this.preInit();
        this.map = new HashMap();
        this.determinatedRenderer = this.initDeterminatedRenderer();
        this.indeterminatedRenderer = this.initIndeterminatedRenderer();
        this.determinedRendererPanel = this.wrapDeterminedRenderer(this.determinatedRenderer);
        this.indeterminedRendererPanel = this.wrapIndeterminedRenderer(this.indeterminatedRenderer);
        this.chooseDeterminated();
        this.defaultBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 1, 2, 1), this.determinatedRenderer.getBorder());
        this.setRowSorter(new ExtDefaultRowSorter<E>(){

            @Override
            public int compare(E o1, E o2) {
                double v2;
                double v1 = (double)ExtProgressColumn.this.getValue(o1) / (double)ExtProgressColumn.this.getMax(o1);
                if (v1 == (v2 = (double)ExtProgressColumn.this.getValue(o2) / (double)ExtProgressColumn.this.getMax(o2))) {
                    return 0;
                }
                if (this.getSortOrderIdentifier() != "ASC") {
                    return v1 > v2 ? -1 : 1;
                }
                return v2 > v1 ? -1 : 1;
            }
        });
    }

    protected void preInit() {
    }

    protected IndeterminatedRenderer<E> initIndeterminatedRenderer() {
        return new IndeterminatedRenderer(this);
    }

    protected RendererProgressBar initDeterminatedRenderer() {
        return new RendererProgressBar();
    }

    @Override
    protected Color getDefaultForeground() {
        return ColorUtils.getContrastBWColor(this.getDefaultBackground());
    }

    @Override
    public void configureEditorComponent(E value, boolean isSelected, int row, int column) {
    }

    @Override
    public void configureRendererComponent(E value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.prepareGetter(value);
        if (this.renderer == this.determinedRendererPanel) {
            double factor;
            long m = this.getMax(value);
            long v = 0L;
            if (m >= 0L && (factor = Math.max((double)(v = this.getValue(value)) / 2.147483647E9, (double)m / 2.147483647E9)) >= 1.0) {
                v = (long)((double)v / factor);
                m = (long)((double)m / factor);
            }
            v = Math.min(m, v);
            this.rendererBar.setMaximum((int)m);
            this.rendererBar.setValue((int)v);
            this.rendererBar.setMinimum(0);
            this.setStringValue(value, m, v);
        } else if (this.renderer == this.indeterminedRendererPanel) {
            this.setStringValue(value, -1L, -1L);
            if (!this.rendererBar.isIndeterminate()) {
                this.rendererBar.setIndeterminate(true);
            }
        } else {
            throw new WTFException();
        }
    }

    protected void setStringValue(E value, long m, long v) {
        this.rendererBar.setString(this.getString(value, v, m));
    }

    @Override
    public Object getCellEditorValue() {
        return null;
    }

    @Override
    public JComponent getEditorComponent(E value, boolean isSelected, int row, int column) {
        return null;
    }

    protected int getFps() {
        return 15;
    }

    protected long getMax(E value) {
        return 100L;
    }

    @Override
    public JComponent getRendererComponent(E value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.columnIndex = column;
        if (this.isIndeterminated(value, isSelected, hasFocus, row, column)) {
            this.chooseIndeterminated();
            if (this.map.size() == 0 && !this.indeterminatedRenderer.isIndeterminate()) {
                this.map.put(value, System.currentTimeMillis());
                this.indeterminatedRenderer.setIndeterminate(true);
            }
            this.map.put(value, System.currentTimeMillis());
        } else {
            this.chooseDeterminated();
            this.map.remove(value);
            if (this.map.size() == 0 && this.indeterminatedRenderer.isIndeterminate()) {
                this.indeterminatedRenderer.setIndeterminate(false);
            }
        }
        return this.renderer;
    }

    protected void chooseDeterminated() {
        this.renderer = this.determinedRendererPanel;
        this.rendererBar = this.determinatedRenderer;
    }

    protected void chooseIndeterminated() {
        this.renderer = this.indeterminedRendererPanel;
        this.rendererBar = this.indeterminatedRenderer;
    }

    protected abstract String getString(E var1, long var2, long var4);

    @Override
    protected String getTooltipText(E value) {
        long m;
        long v = this.getValue(value);
        double factor = Math.max((double)v / 2.147483647E9, (double)(m = this.getMax(value)) / 2.147483647E9);
        if (factor >= 1.0) {
            v = (long)((double)v / factor);
            m = (long)((double)m / factor);
        }
        return this.getString(value, v, m);
    }

    protected abstract long getValue(E var1);

    @Override
    public boolean isEditable(E obj) {
        return false;
    }

    @Override
    public boolean isEnabled(E obj) {
        return true;
    }

    protected boolean isIndeterminated(E value, boolean isSelected, boolean hasFocus, int row, int column) {
        return false;
    }

    @Override
    public boolean isSortable(E obj) {
        return true;
    }

    protected void prepareGetter(E value) {
    }

    @Override
    public void resetEditor() {
    }

    @Override
    public void resetRenderer() {
        this.renderer.setOpaque(false);
        this.rendererBar.setStringPainted(true);
        this.rendererBar.setOpaque(false);
        this.rendererBar.setBorder(this.defaultBorder);
    }

    @Override
    public void setValue(Object value, E object) {
    }

    public static final class IndeterminatedRenderer<E>
    extends RendererProgressBar {
        private static final long serialVersionUID = 1L;
        private long cleanupTimer = 0L;
        private volatile boolean indeterminate = false;
        private volatile long timer = 0L;
        private ExtProgressColumn<E> column;

        public IndeterminatedRenderer(ExtProgressColumn<E> column) {
            this.column = column;
        }

        @Override
        public boolean isDisplayable() {
            return true;
        }

        @Override
        public boolean isIndeterminate() {
            return this.indeterminate;
        }

        @Override
        public boolean isVisible() {
            return true;
        }

        @Override
        public void repaint() {
            if (this.column == null) {
                return;
            }
            if (this.column.isModifying()) {
                return;
            }
            ExtTableModel mod = this.column.getModel();
            if (mod != null && mod.getTable() != null && this.column.indeterminatedRenderer.isIndeterminate() && mod.getTable().isShowing()) {
                if (System.currentTimeMillis() - this.cleanupTimer > 30000L) {
                    Iterator it = ((ExtProgressColumn)this.column).map.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry next = it.next();
                        long lastUpdate = System.currentTimeMillis() - (Long)next.getValue();
                        if (lastUpdate <= 5000L) continue;
                        it.remove();
                    }
                    this.cleanupTimer = System.currentTimeMillis();
                    if (((ExtProgressColumn)this.column).map.size() == 0 && this.column.indeterminatedRenderer.isIndeterminate()) {
                        this.column.indeterminatedRenderer.setIndeterminate(false);
                        return;
                    }
                }
                if (((ExtProgressColumn)this.column).columnIndex >= 0 && System.currentTimeMillis() - this.timer > (long)(1000 / this.column.getFps())) {
                    ((ExtProgressColumn)this.column).repaint();
                    this.timer = System.currentTimeMillis();
                }
            }
        }

        @Override
        public void repaint(Rectangle r) {
            this.repaint();
        }

        @Override
        public void setIndeterminate(boolean newValue) {
            if (newValue == this.indeterminate) {
                return;
            }
            this.indeterminate = newValue;
            super.setIndeterminate(newValue);
        }
    }
}

