/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.testframework.tests;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.tests.ClassPathScanner;
import org.appwork.testframework.AWTest;
import org.appwork.testframework.PostBuildTestInterface;
import org.appwork.utils.Files;
import org.appwork.utils.ZipContentHasher;

public class AssertNoTestsInJars
implements PostBuildTestInterface {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateZipOrJar(File folder) throws Exception {
        for (File f : Files.getFiles(true, true, folder)) {
            String jarSigner;
            if (!f.getName().toLowerCase(Locale.ROOT).endsWith(".jar") && !f.getName().toLowerCase(Locale.ROOT).endsWith(".zip")) continue;
            if (f.getName().toLowerCase(Locale.ROOT).endsWith(".jar") && (jarSigner = AWTest.verifyJar(f)).equals("jar is unsigned.")) {
                AWTest.logInfoAnyway("[WARNING] Unsigned JAR: " + f);
            }
            FileInputStream is = new FileInputStream(f);
            try {
                AWTest.validateZipOrJar(f.getAbsolutePath(), is);
            }
            finally {
                is.close();
            }
        }
    }

    @Override
    public void runPostBuildTest(String[] args, File applicationRoot) throws Exception {
        this.validateZipOrJar(applicationRoot);
        for (URL url : ClassPathScanner.getClassPath()) {
            final File root = new File(url.toURI());
            if (root == null || !root.isFile()) continue;
            ZipContentHasher.getContentSHA256(root, new ZipContentHasher.Customizer(){

                @Override
                public boolean handle(String path, ZipInputStream zipStream, ZipEntry entry, HashMap<String, byte[]> results) throws IOException {
                    if (entry.getName().matches("this.is.an.allowed.test.path")) {
                        return false;
                    }
                    if (entry.getName().matches("org/bouncycastle/util/test/.*")) {
                        return false;
                    }
                    if (entry.getName().matches("(?i).*/tests?/.*")) {
                        throw new WTFException("Found test namespace: " + entry.getName() + " in " + root + " - " + path);
                    }
                    if (entry.getName().matches("(?i).*/ide/.*")) {
                        throw new WTFException("Found ide namespace: " + entry.getName() + " in " + root + " - " + path);
                    }
                    return false;
                }
            });
        }
    }
}

